/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.any.NumericAnyVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleAnyVectorAggregator
extends NumericAnyVectorAggregator {
    public DoubleAnyVectorAggregator(VectorValueSelector selector) {
        super(selector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putDouble(position, 0.0);
    }

    @Override
    boolean putAnyValueFromRow(ByteBuffer buf, int position, int startRow, int endRow) {
        boolean isRowsWithinIndex;
        double[] values = this.vectorValueSelector.getDoubleVector();
        boolean bl = isRowsWithinIndex = startRow < endRow && startRow < values.length;
        if (isRowsWithinIndex) {
            buf.putDouble(position, values[startRow]);
        }
        return isRowsWithinIndex;
    }

    @Override
    Object getNonNullObject(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }
}

