/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.StructuredData;

public class AutoTypeColumnSchema
extends DimensionSchema {
    public static final String TYPE = "auto";
    @Nullable
    private final ColumnType castToType;
    @Nullable
    private final NestedCommonFormatColumnFormatSpec columnFormatSpec;

    public static AutoTypeColumnSchema of(String name) {
        return new AutoTypeColumnSchema(name, null, null);
    }

    @JsonCreator
    public AutoTypeColumnSchema(@JsonProperty(value="name") String name, @JsonProperty(value="castToType") @Nullable ColumnType castToType, @JsonProperty(value="columnFormatSpec") @Nullable NestedCommonFormatColumnFormatSpec columnFormatSpec) {
        super(name, null, true);
        this.castToType = ColumnType.FLOAT.equals(castToType) ? ColumnType.DOUBLE : (ColumnType.FLOAT_ARRAY.equals(castToType) ? ColumnType.DOUBLE_ARRAY : castToType);
        this.columnFormatSpec = columnFormatSpec;
    }

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public ColumnType getColumnType() {
        return this.castToType != null ? this.castToType : ColumnType.NESTED_DATA;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ColumnType getCastToType() {
        return this.castToType;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public NestedCommonFormatColumnFormatSpec getColumnFormatSpec() {
        return this.columnFormatSpec;
    }

    @Override
    public DimensionHandler<StructuredData, StructuredData, StructuredData> getDimensionHandler() {
        return new NestedCommonFormatColumnHandler(this.getName(), this.castToType, this.columnFormatSpec);
    }

    @Override
    public DimensionSchema getEffectiveSchema(IndexSpec indexSpec) {
        return new AutoTypeColumnSchema(this.getName(), this.castToType, NestedCommonFormatColumnFormatSpec.getEffectiveFormatSpec(this.columnFormatSpec, indexSpec));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AutoTypeColumnSchema that = (AutoTypeColumnSchema)o;
        return Objects.equals(this.castToType, that.castToType) && Objects.equals(this.columnFormatSpec, that.columnFormatSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.castToType, this.columnFormatSpec);
    }

    @Override
    public String toString() {
        return "DimensionSchema{name='" + this.getName() + "', valueType=" + String.valueOf(this.getColumnType()) + ", typeName=" + this.getTypeName() + ", multiValueHandling=" + String.valueOf((Object)this.getMultiValueHandling()) + ", createBitmapIndex=" + this.hasBitmapIndex() + ", castToType=" + String.valueOf(this.castToType) + ", columnFormatSpec=" + String.valueOf(this.columnFormatSpec) + "}";
    }
}

