/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.data.FrontCodedIndexed;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Utf8.class, name="utf8"), @JsonSubTypes.Type(value=FrontCoded.class, name="frontCoded")})
public interface StringEncodingStrategy {
    public static final Utf8 UTF8_STRATEGY;
    public static final Utf8 DEFAULT;
    public static final String UTF8 = "utf8";
    public static final String FRONT_CODED = "frontCoded";
    public static final byte UTF8_ID = 0;
    public static final byte FRONT_CODED_ID = 1;

    public String getType();

    public byte getId();

    static {
        DEFAULT = UTF8_STRATEGY = new Utf8();
    }

    public static class Utf8
    implements StringEncodingStrategy {
        @Override
        public String getType() {
            return StringEncodingStrategy.UTF8;
        }

        @Override
        public byte getId() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hashCode(StringEncodingStrategy.UTF8);
        }

        public String toString() {
            return "Utf8{}";
        }
    }

    public static class FrontCoded
    implements StringEncodingStrategy {
        @JsonProperty
        private final int bucketSize;
        @JsonProperty
        private final byte formatVersion;

        @JsonCreator
        public FrontCoded(@JsonProperty(value="bucketSize") @Nullable Integer bucketSize, @JsonProperty(value="formatVersion") @Nullable Byte version) {
            int n = this.bucketSize = bucketSize == null ? 4 : bucketSize;
            if (Integer.bitCount(this.bucketSize) != 1) {
                throw new ISE("bucketSize must be a power of two but was[%,d]", bucketSize);
            }
            this.formatVersion = version == null ? (byte)0 : FrontCodedIndexed.validateVersion(version);
        }

        public FrontCoded(@Nullable Integer bucketSize) {
            this(bucketSize, null);
        }

        @JsonProperty
        public int getBucketSize() {
            return this.bucketSize;
        }

        @JsonProperty
        public byte getFormatVersion() {
            return this.formatVersion;
        }

        @Override
        public String getType() {
            return StringEncodingStrategy.FRONT_CODED;
        }

        @Override
        public byte getId() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrontCoded that = (FrontCoded)o;
            return this.bucketSize == that.bucketSize && this.formatVersion == that.formatVersion;
        }

        public int hashCode() {
            return Objects.hash(this.bucketSize, this.formatVersion);
        }

        public String toString() {
            return "FrontCoded{bucketSize=" + this.bucketSize + ", formatVersion=" + this.formatVersion + "}";
        }
    }
}

