/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import javax.annotation.Nullable;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.incremental.IncrementalIndex;

public class IncrementalIndexPhysicalSegmentInspector
implements PhysicalSegmentInspector {
    static final ColumnCapabilities.CoercionLogic SNAPSHOT_COERCE_LOGIC = new ColumnCapabilities.CoercionLogic(){

        @Override
        public boolean dictionaryEncoded() {
            return true;
        }

        @Override
        public boolean dictionaryValuesSorted() {
            return true;
        }

        @Override
        public boolean dictionaryValuesUnique() {
            return true;
        }

        @Override
        public boolean multipleValues() {
            return false;
        }

        @Override
        public boolean hasNulls() {
            return false;
        }
    };
    private final IncrementalIndex index;

    public IncrementalIndexPhysicalSegmentInspector(IncrementalIndex index) {
        this.index = index;
    }

    @Override
    @Nullable
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer<?, ?, ?> indexer = desc.getIndexer();
        return indexer.getMinValue();
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer<?, ?, ?> indexer = desc.getIndexer();
        return indexer.getMaxValue();
    }

    @Override
    public int getDimensionCardinality(String column) {
        if (column.equals("__time")) {
            return -1;
        }
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return 1;
        }
        return desc.getIndexer().getCardinality();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return ColumnCapabilitiesImpl.snapshot(this.index.getColumnCapabilities(column), SNAPSHOT_COERCE_LOGIC);
    }

    @Override
    public int getNumRows() {
        return this.index.numRows();
    }
}

