/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.utils.CollectionUtils;

public class ExternalDestinationSqlIdentifier
extends SqlIdentifier {
    private final Map<String, String> properties;

    public ExternalDestinationSqlIdentifier(String name, SqlParserPos pos, Map<String, String> properties) {
        super(name, pos);
        this.properties = properties;
    }

    public String getDestinationType() {
        return (String)CollectionUtils.getOnlyElement((Iterable)this.names, x -> DruidException.defensive((String)"Expected single name in external destination identifier, but got [%s]", (Object[])new Object[]{this.names}));
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame externFrame = writer.startFunCall("EXTERN");
        SqlWriter.Frame frame = writer.startFunCall(this.getDestinationType());
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            writer.sep(",");
            writer.print(StringUtils.format((String)"%s => '%s'", (Object[])new Object[]{property.getKey(), property.getValue()}));
        }
        writer.endFunCall(frame);
        writer.endFunCall(externFrame);
    }

    public SqlNode clone(SqlParserPos pos) {
        String name = (String)CollectionUtils.getOnlyElement((Iterable)this.names, x -> DruidException.defensive((String)"Expected single name in external destination identifier, but got [%s]", (Object[])new Object[]{this.names}));
        return new ExternalDestinationSqlIdentifier(name, pos, this.properties);
    }

    @Deprecated
    public Object clone() {
        throw DruidException.defensive((String)"Function is deprecated, please use clone(SqlNode) instead.", (Object[])new Object[0]);
    }

    public ExportStorageProvider toExportStorageProvider(ObjectMapper objectMapper) {
        HashMap<String, String> storageConnectorProperties = new HashMap<String, String>(this.properties);
        storageConnectorProperties.put("type", this.getDestinationType());
        return (ExportStorageProvider)objectMapper.convertValue(storageConnectorProperties, ExportStorageProvider.class);
    }
}

