/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.QueryResponse;

public class PlannerResult {
    private final Supplier<QueryResponse<Object[]>> resultsSupplier;
    private final RelDataType rowType;
    private final AtomicBoolean didRun = new AtomicBoolean();

    public PlannerResult(Supplier<QueryResponse<Object[]>> resultsSupplier, RelDataType rowType) {
        this.resultsSupplier = resultsSupplier;
        this.rowType = rowType;
    }

    public boolean runnable() {
        return !this.didRun.get();
    }

    public QueryResponse<Object[]> run() {
        if (!this.didRun.compareAndSet(false, true)) {
            throw new ISE("Cannot run more than once", new Object[0]);
        }
        return (QueryResponse)this.resultsSupplier.get();
    }

    public RelDataType rowType() {
        return this.rowType;
    }
}

