/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class CaseToCoalesceRule
extends RelOptRule
implements SubstitutionRule {
    public CaseToCoalesceRule() {
        super(CaseToCoalesceRule.operand(RelNode.class, (RelOptRuleOperandChildren)CaseToCoalesceRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        CaseToCoalesceShuttle shuttle;
        RelNode oldNode = call.rel(0);
        RelNode newNode = oldNode.accept((RexShuttle)(shuttle = new CaseToCoalesceShuttle(oldNode.getCluster().getRexBuilder())));
        if (newNode != oldNode) {
            call.transformTo(newNode);
            call.getPlanner().prune(oldNode);
        }
    }

    private static boolean isCoalesceWhenThen(RelDataTypeFactory typeFactory, RexNode when, RexNode then) {
        if (when.isA(SqlKind.IS_NOT_NULL)) {
            RexNode whenIsNotNullArg = RexUtil.removeNullabilityCast((RelDataTypeFactory)typeFactory, (RexNode)((RexNode)((RexCall)when).getOperands().get(0)));
            return whenIsNotNullArg.equals((Object)RexUtil.removeNullabilityCast((RelDataTypeFactory)typeFactory, (RexNode)then));
        }
        return false;
    }

    private static class CaseToCoalesceShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public CaseToCoalesceShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            if (call.getKind() == SqlKind.CASE) {
                List caseArgs = call.getOperands();
                ArrayList<RexNode> coalesceArgs = new ArrayList<RexNode>();
                for (int i = 0; i < caseArgs.size(); i += 2) {
                    if (i == caseArgs.size() - 1) {
                        if (coalesceArgs.isEmpty()) {
                            return super.visitCall(call);
                        }
                        coalesceArgs.add((RexNode)caseArgs.get(i));
                        continue;
                    }
                    if (CaseToCoalesceRule.isCoalesceWhenThen(this.rexBuilder.getTypeFactory(), (RexNode)caseArgs.get(i), (RexNode)caseArgs.get(i + 1))) {
                        coalesceArgs.add((RexNode)((RexCall)caseArgs.get(i)).getOperands().get(0));
                        continue;
                    }
                    return super.visitCall(call);
                }
                return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, coalesceArgs);
            }
            return super.visitCall(call);
        }
    }
}

