/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli.convert;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.cli.convert.PropertyConverter;
import org.apache.druid.cli.convert.Rename;

public class DataSegmentPusherDefaultConverter
implements PropertyConverter {
    Set<String> propertiesHandled = Sets.newHashSet((Object[])new String[]{"druid.pusher.local", "druid.pusher.cassandra", "druid.pusher.hdfs"});

    @Override
    public boolean canHandle(String property) {
        return this.propertiesHandled.contains(property) || property.startsWith("druid.pusher.s3");
    }

    @Override
    public Map<String, String> convert(Properties props) {
        String type = null;
        if (Boolean.parseBoolean(props.getProperty("druid.pusher.local", "false"))) {
            type = "local";
        } else if (Boolean.parseBoolean(props.getProperty("druid.pusher.cassandra", "false"))) {
            type = "c*";
        } else if (Boolean.parseBoolean(props.getProperty("druid.pusher.hdfs", "false"))) {
            type = "hdfs";
        }
        if (type != null) {
            return ImmutableMap.of((Object)"druid.storage.type", (Object)type);
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        retVal.put("druid.pusher.type", type);
        retVal.putAll(new Rename("druid.pusher.s3.bucket", "druid.storage.bucket").convert(props));
        retVal.putAll(new Rename("druid.pusher.s3.baseKey", "druid.storage.baseKey").convert(props));
        retVal.putAll(new Rename("druid.pusher.s3.disableAcl", "druid.storage.disableAcl").convert(props));
        return retVal;
    }
}

