/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchUnaryPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class ArrayOfDoublesSketchToMeansPostAggregator
extends ArrayOfDoublesSketchUnaryPostAggregator {
    @JsonCreator
    public ArrayOfDoublesSketchToMeansPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field) {
        super(name, field);
    }

    public double[] compute(Map<String, Object> combinedAggregators) {
        ArrayOfDoublesSketch sketch = (ArrayOfDoublesSketch)this.getField().compute(combinedAggregators);
        SummaryStatistics[] stats = new SummaryStatistics[sketch.getNumValues()];
        Arrays.setAll(stats, i -> new SummaryStatistics());
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            double[] values = it.getValues();
            for (int i2 = 0; i2 < values.length; ++i2) {
                stats[i2].addValue(values[i2]);
            }
        }
        double[] means = new double[sketch.getNumValues()];
        Arrays.setAll(means, i -> stats[i].getMean());
        return means;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE_ARRAY;
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing arrays of mean values is not supported", new Object[0]);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(37).appendCacheable((Cacheable)this.getField()).build();
    }
}

