/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.ExecutionContext;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.RunWorkOrderListener;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;

public class ExecutionContextImpl
implements ExecutionContext {
    private final WorkOrder workOrder;
    private final FrameProcessorExecutor executor;
    private final InputSliceReader inputSliceReader;
    private final IntermediateOutputChannelFactoryMaker intermediateOutputChannelFactoryMaker;
    private final OutputChannelFactory outputChannelFactory;
    private final SettableFuture<ClusterByPartitions> globalClusterByPartitionsFuture;
    private final FrameContext frameContext;
    private final CounterTracker counters;
    private final int maxOutstandingProcessors;
    private final String cancellationId;
    private final RunWorkOrderListener listener;
    private final Set<String> intermediateOutputChannelFactoryNames = Sets.newConcurrentHashSet();

    ExecutionContextImpl(WorkOrder workOrder, FrameProcessorExecutor executor, InputSliceReader inputSliceReader, IntermediateOutputChannelFactoryMaker intermediateOutputChannelFactoryMaker, OutputChannelFactory outputChannelFactory, SettableFuture<ClusterByPartitions> globalClusterByPartitionsFuture, FrameContext frameContext, CounterTracker counters, int maxOutstandingProcessors, String cancellationId, RunWorkOrderListener listener) {
        this.workOrder = workOrder;
        this.executor = executor;
        this.inputSliceReader = inputSliceReader;
        this.intermediateOutputChannelFactoryMaker = intermediateOutputChannelFactoryMaker;
        this.outputChannelFactory = outputChannelFactory;
        this.globalClusterByPartitionsFuture = globalClusterByPartitionsFuture;
        this.frameContext = frameContext;
        this.counters = counters;
        this.maxOutstandingProcessors = maxOutstandingProcessors;
        this.cancellationId = cancellationId;
        this.listener = listener;
    }

    @Override
    public WorkOrder workOrder() {
        return this.workOrder;
    }

    @Override
    public FrameProcessorExecutor executor() {
        return this.executor;
    }

    @Override
    public InputSliceReader inputSliceReader() {
        return this.inputSliceReader;
    }

    @Override
    public ListenableFuture<ClusterByPartitions> globalClusterByPartitions() {
        return this.globalClusterByPartitionsFuture;
    }

    @Override
    public OutputChannelFactory outputChannelFactory() {
        return this.outputChannelFactory;
    }

    @Override
    public OutputChannelFactory makeIntermediateOutputChannelFactory(String name) {
        if (this.intermediateOutputChannelFactoryNames.add(name)) {
            return this.intermediateOutputChannelFactoryMaker.makeFactory(name);
        }
        throw DruidException.defensive((String)"Cannot use intermediate output channel factory name[%s] multiple times", (Object[])new Object[]{name});
    }

    @Override
    public FrameContext frameContext() {
        return this.frameContext;
    }

    @Override
    public CounterTracker counters() {
        return this.counters;
    }

    @Override
    public int threadCount() {
        return this.maxOutstandingProcessors;
    }

    @Override
    public String cancellationId() {
        return this.cancellationId;
    }

    @Override
    public Bouncer processingBouncer() {
        if (this.workOrder.getStageDefinition().getProcessor().usesProcessingBuffers()) {
            Bouncer baseBouncer = this.frameContext.processingBuffers().getBouncer();
            if (this.maxOutstandingProcessors < baseBouncer.getMaxCount()) {
                return new Bouncer(this.maxOutstandingProcessors, baseBouncer);
            }
            return baseBouncer;
        }
        return new Bouncer(this.maxOutstandingProcessors);
    }

    @Override
    public void onDoneReadingInput(@Nullable ClusterByStatisticsSnapshot snapshot) {
        this.listener.onDoneReadingInput(snapshot);
    }

    @Override
    public void onWarning(Throwable t) {
        this.listener.onWarning(t);
    }

    static interface IntermediateOutputChannelFactoryMaker {
        public OutputChannelFactory makeFactory(String var1);
    }
}

