/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyColumns")
public class TooManyColumnsFault
extends BaseMSQFault {
    static final String CODE = "TooManyColumns";
    private final int numColumns;
    private final int maxColumns;

    @JsonCreator
    public TooManyColumnsFault(@JsonProperty(value="numColumns") int numColumns, @JsonProperty(value="maxColumns") int maxColumns) {
        super(CODE, "Too many output columns (requested = %d, max = %d)", numColumns, maxColumns);
        this.numColumns = numColumns;
        this.maxColumns = maxColumns;
    }

    @JsonProperty
    public int getNumColumns() {
        return this.numColumns;
    }

    @JsonProperty
    public int getMaxColumns() {
        return this.maxColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyColumnsFault that = (TooManyColumnsFault)o;
        return this.numColumns == that.numColumns && this.maxColumns == that.maxColumns;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numColumns, this.maxColumns);
    }
}

