/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.indexing.CountingReadableFrameChannel;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.stage.InputChannels;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.StagePartition;

public class StageInputSliceReader
implements InputSliceReader {
    private final String queryId;
    private final InputChannels inputChannels;

    public StageInputSliceReader(String queryId, InputChannels inputChannels) {
        this.queryId = queryId;
        this.inputChannels = inputChannels;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        StageInputSlice stageInputSlice = (StageInputSlice)slice;
        return Iterables.size((Iterable)stageInputSlice.getPartitions());
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        StageInputSlice stageInputSlice = (StageInputSlice)slice;
        StageId stageId = new StageId(this.queryId, stageInputSlice.getStageNumber());
        FrameReader frameReader = this.inputChannels.frameReader(stageInputSlice.getStageNumber());
        return ReadableInputs.channels(() -> Iterators.transform(stageInputSlice.getPartitions().iterator(), partition -> {
            StagePartition stagePartition = new StagePartition(stageId, partition.getPartitionNumber());
            try {
                return ReadableInput.channel(new CountingReadableFrameChannel(this.inputChannels.openChannel(stagePartition), counters.channel(CounterNames.inputChannel(inputNumber)), stagePartition.getPartitionNumber()), frameReader, stagePartition);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }), frameReader);
    }
}

