/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.RpcException;

public class HttpResponseException
extends RpcException {
    private final StringFullResponseHolder responseHolder;

    public HttpResponseException(StringFullResponseHolder responseHolder) {
        super("Server error [%s]; %s", responseHolder.getStatus(), HttpResponseException.choppedBodyErrorMessage(responseHolder.getContent()));
        this.responseHolder = responseHolder;
    }

    public StringFullResponseHolder getResponse() {
        return this.responseHolder;
    }

    static String choppedBodyErrorMessage(@Nullable String responseContent) {
        if (responseContent == null || responseContent.isEmpty()) {
            return "no body";
        }
        if (responseContent.length() > 1000) {
            String choppedMessage = StringUtils.chop((String)responseContent, (int)1000);
            return "first 1KB of body: " + choppedMessage;
        }
        return "body: " + responseContent;
    }
}

