/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventBuilder;

public final class LogUtil {
    private static final String FQCN = LogUtil.class.getName();

    public static void debug(Logger logger, String format, Supplier<?> objectSupplier) {
        LoggingEventBuilder builder = logger.atDebug();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        builder.addArgument(objectSupplier).log(format);
    }

    public static void debug(Logger logger, String format, Supplier<?> objectSupplier, Throwable t) {
        LoggingEventBuilder builder = logger.atDebug();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        builder.addArgument(objectSupplier).setCause(t).log(format);
    }

    public static void debug(Logger logger, String format, Supplier<?> ... objectSuppliers) {
        LoggingEventBuilder builder = logger.atDebug();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        for (Supplier<?> objectSupplier : objectSuppliers) {
            builder = builder.addArgument(objectSupplier);
        }
        builder.log(format);
    }

    public static void info(Logger logger, String format, Supplier<?> objectSupplier) {
        LoggingEventBuilder builder = logger.atInfo();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        builder.addArgument(objectSupplier).log(format);
    }

    public static void info(Logger logger, String format, Supplier<?> objectSupplier, Throwable t) {
        LoggingEventBuilder builder = logger.atInfo();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        builder.addArgument(objectSupplier).setCause(t).log(format);
    }

    public static void info(Logger logger, String format, Supplier<?> ... objectSuppliers) {
        LoggingEventBuilder builder = logger.atInfo();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        for (Supplier<?> objectSupplier : objectSuppliers) {
            builder = builder.addArgument(objectSupplier);
        }
        builder.log(format);
    }

    public static void warn(Logger logger, String format, Supplier<?> objectSupplier) {
        LoggingEventBuilder builder = logger.atWarn();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        builder.addArgument(objectSupplier).log(format);
    }

    public static void warn(Logger logger, String format, Supplier<?> objectSupplier, Throwable t) {
        LoggingEventBuilder builder = logger.atWarn();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        builder.addArgument(objectSupplier).setCause(t).log(format);
    }

    public static void warn(Logger logger, String format, Supplier<?> ... objectSuppliers) {
        LoggingEventBuilder builder = logger.atWarn();
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(FQCN);
        }
        for (Supplier<?> objectSupplier : objectSuppliers) {
            builder = builder.addArgument(objectSupplier);
        }
        builder.log(format);
    }

    @Generated
    private LogUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

