/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.sink.connector;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mq.kafka.KafkaSinkConfig;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaSinkConnector.class);
    private KafkaSinkConfig sinkConfig;
    private final Properties props = new Properties();
    Producer<String, String> producer;

    public Class<? extends Config> configClass() {
        return KafkaSinkConfig.class;
    }

    public void init(Config config) {
        this.sinkConfig = (KafkaSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (KafkaSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() {
        this.props.put("bootstrap.servers", this.sinkConfig.getConnectorConfig().getBootstrapServers());
        this.props.put("key.serializer", this.sinkConfig.getConnectorConfig().getKeyConverter());
        this.props.put("value.serializer", this.sinkConfig.getConnectorConfig().getValueConverter());
        this.props.put("acks", this.sinkConfig.getConnectorConfig().getAck());
        this.props.put("max.request.size", this.sinkConfig.getConnectorConfig().getMaxRequestSize());
        this.props.put("buffer.memory", this.sinkConfig.getConnectorConfig().getBufferMemory());
        this.props.put("batch.size", this.sinkConfig.getConnectorConfig().getBatchSize());
        this.props.put("linger.ms", this.sinkConfig.getConnectorConfig().getLingerMs());
        this.props.put("request.timeout.ms", this.sinkConfig.getConnectorConfig().getRequestTimeoutMs());
        this.props.put("max.in.flight.requests.per.connection", this.sinkConfig.getConnectorConfig().getMaxInFightRequestsPerConnection());
        this.props.put("retries", this.sinkConfig.getConnectorConfig().getRetries());
        this.props.put("compression.type", this.sinkConfig.getConnectorConfig().getCompressionType());
        this.producer = new KafkaProducer(this.props);
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.producer.close();
    }

    public void put(List<ConnectRecord> sinkRecords) {
        try {
            for (ConnectRecord connectRecord : sinkRecords) {
                ProducerRecord message = this.convertRecordToMessage(connectRecord);
                this.producer.send(message, (metadata, exception) -> {
                    if (exception == null) {
                        log.debug("Produced message to topic:{},partition:{},offset:{}", new Object[]{metadata.topic(), metadata.partition(), metadata.offset()});
                    } else {
                        log.error("Failed to produce message:{}", (Object)exception.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Failed to produce message:{}", (Object)e.getMessage());
        }
    }

    public ProducerRecord convertRecordToMessage(ConnectRecord connectRecord) {
        ArrayList<RecordHeader> headers = new ArrayList<RecordHeader>();
        for (String key : connectRecord.getExtensions().keySet()) {
            headers.add(new RecordHeader(key, connectRecord.getExtension(key).getBytes(StandardCharsets.UTF_8)));
        }
        ProducerRecord message = new ProducerRecord(this.sinkConfig.getConnectorConfig().getTopic(), null, (Object)"", (Object)new String((byte[])connectRecord.getData(), StandardCharsets.UTF_8), headers);
        return message;
    }
}

