/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.convertor;

import java.math.BigDecimal;
import org.redisson.client.protocol.convertor.Convertor;

public class LongNumberConvertor
implements Convertor<Object> {
    private Class<?> resultClass;

    public LongNumberConvertor(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    @Override
    public Object convert(Object result) {
        Number res;
        if (result instanceof Long) {
            res = (Long)result;
            if (this.resultClass.isAssignableFrom(Long.class)) {
                return res;
            }
            if (this.resultClass.isAssignableFrom(Integer.class)) {
                return ((Long)res).intValue();
            }
            if (this.resultClass.isAssignableFrom(BigDecimal.class)) {
                return new BigDecimal((Long)res);
            }
        }
        if (result instanceof Double) {
            res = (Double)result;
            if (this.resultClass.isAssignableFrom(Float.class)) {
                return Float.valueOf(((Double)result).floatValue());
            }
            if (this.resultClass.isAssignableFrom(Double.class)) {
                return res;
            }
        }
        throw new IllegalStateException("Wrong value type!");
    }
}

