/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.cache;

import com.navercorp.pinpoint.common.util.BytesUtils;
import java.util.concurrent.atomic.AtomicInteger;

public interface IdAllocator {
    public int allocate();

    public static class BypassAllocator
    implements IdAllocator {
        private final AtomicInteger idGen;

        public BypassAllocator() {
            this(1);
        }

        public BypassAllocator(int startValue) {
            this.idGen = new AtomicInteger(startValue);
        }

        @Override
        public int allocate() {
            return this.idGen.getAndIncrement();
        }
    }

    public static class ZigZagAllocator
    implements IdAllocator {
        private final AtomicInteger idGen;

        public ZigZagAllocator() {
            this(1);
        }

        public ZigZagAllocator(int startValue) {
            this.idGen = new AtomicInteger(startValue);
        }

        @Override
        public int allocate() {
            int id = this.idGen.getAndIncrement();
            return BytesUtils.zigzagToInt((int)id);
        }
    }

    public static enum ID_TYPE {
        BYPASS,
        ZIGZAG;

    }
}

