/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.errorhandler.AlwaysMessageMatcher;
import com.navercorp.pinpoint.profiler.context.errorhandler.BypassErrorHandler;
import com.navercorp.pinpoint.profiler.context.errorhandler.ClassNameThrowableMatcher;
import com.navercorp.pinpoint.profiler.context.errorhandler.ContainsMessageMatcher;
import com.navercorp.pinpoint.profiler.context.errorhandler.DefaultIgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.errorhandler.Descriptor;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.errorhandler.MessageMatcher;
import com.navercorp.pinpoint.profiler.context.errorhandler.MultipleErrorHandler;
import com.navercorp.pinpoint.profiler.context.errorhandler.NestedErrorHandler;
import com.navercorp.pinpoint.profiler.context.errorhandler.ParentClassThrowableMatcher;
import com.navercorp.pinpoint.profiler.context.errorhandler.ThrowableMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ErrorHandlerBuilder {
    private final List<Descriptor> descriptorList;
    private final AlwaysMessageMatcher ALWAYS = new AlwaysMessageMatcher();

    public ErrorHandlerBuilder(List<Descriptor> descriptorList) {
        this.descriptorList = Objects.requireNonNull(descriptorList, "descriptorList");
    }

    public IgnoreErrorHandler build() {
        ArrayList<DefaultIgnoreErrorHandler> errorHandlerList = new ArrayList<DefaultIgnoreErrorHandler>();
        for (Descriptor desc : this.descriptorList) {
            ThrowableMatcher throwableMatcher = this.newThrowableMatcher(desc);
            MessageMatcher messageMatcher = this.newMessageMatcher(desc.getContainsExceptionMessages());
            IgnoreErrorHandler errorHandler = new DefaultIgnoreErrorHandler(desc.getHandlerId(), throwableMatcher, messageMatcher);
            if (desc.isNestedSearch()) {
                errorHandler = new NestedErrorHandler(errorHandler);
            }
            errorHandlerList.add((DefaultIgnoreErrorHandler)errorHandler);
        }
        if (errorHandlerList.isEmpty()) {
            return new BypassErrorHandler();
        }
        return new MultipleErrorHandler(errorHandlerList.toArray(new IgnoreErrorHandler[0]));
    }

    private ThrowableMatcher newThrowableMatcher(Descriptor descriptor) {
        List<String> classNames = descriptor.getClassNames();
        ThrowableMatcher throwableMatcher = new ClassNameThrowableMatcher(classNames.toArray(new String[0]));
        if (descriptor.isParentSearch()) {
            throwableMatcher = new ParentClassThrowableMatcher(throwableMatcher);
        }
        return throwableMatcher;
    }

    private MessageMatcher newMessageMatcher(List<String> containsExceptionMessages) {
        if (CollectionUtils.isEmpty(containsExceptionMessages)) {
            return this.ALWAYS;
        }
        String[] patterns = containsExceptionMessages.toArray(new String[0]);
        return new ContainsMessageMatcher(patterns);
    }
}

