/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import com.navercorp.pinpoint.profiler.context.errorhandler.ThrowableMatcher;
import java.util.Objects;

public class ParentClassThrowableMatcher
implements ThrowableMatcher {
    private final ThrowableMatcher throwableMatcher;

    public ParentClassThrowableMatcher(ThrowableMatcher throwableMatcher) {
        this.throwableMatcher = Objects.requireNonNull(throwableMatcher, "throwableMatcher");
    }

    @Override
    public boolean match(Class<? extends Throwable> throwableClass) {
        while (throwableClass != null) {
            if (this.throwableMatcher.match(throwableClass)) {
                return true;
            }
            Class<? extends Throwable> superclass = throwableClass.getSuperclass();
            if (!Throwable.class.isAssignableFrom(superclass)) {
                return false;
            }
            throwableClass = superclass;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentClassThrowableMatcher{");
        sb.append("throwableMatcher=").append(this.throwableMatcher);
        sb.append('}');
        return sb.toString();
    }
}

