/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.cpu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.JvmType;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CpuLoadMetricProvider
implements Provider<CpuLoadMetric> {
    private static final String ORACLE_CPU_LOAD_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.cpu.oracle.DefaultCpuLoadMetric";
    private static final String IBM_CPU_LOAD_METRIC = "com.navercorp.pinpoint.profiler.monitor.metric.cpu.ibm.DefaultCpuLoadMetric";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String vendorName;

    @Inject
    public CpuLoadMetricProvider(ContextConfig contextConfig) {
        Objects.requireNonNull(contextConfig, "contextConfig");
        this.vendorName = contextConfig.getProfilerJvmVendorName();
    }

    public CpuLoadMetric get() {
        JvmType jvmType = JvmType.fromVendor((String)this.vendorName);
        if (jvmType == JvmType.UNKNOWN) {
            jvmType = JvmUtils.getType();
        }
        String classToLoad = this.getCpuLoadMetricClassName(jvmType);
        CpuLoadMetric cpuLoadMetric = this.createCpuLoadMetric(classToLoad);
        this.logger.info("loaded : {}", (Object)cpuLoadMetric);
        return cpuLoadMetric;
    }

    private String getCpuLoadMetricClassName(JvmType jvmType) {
        if (jvmType == JvmType.ORACLE || jvmType == JvmType.OPENJDK) {
            return ORACLE_CPU_LOAD_METRIC;
        }
        if (jvmType == JvmType.IBM) {
            return IBM_CPU_LOAD_METRIC;
        }
        return null;
    }

    private CpuLoadMetric createCpuLoadMetric(String classToLoad) {
        if (classToLoad == null) {
            return CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC;
        }
        try {
            Class<?> cpuLoadMetricClass = Class.forName(classToLoad);
            try {
                Constructor<?> cpuLoadMetricConstructor = cpuLoadMetricClass.getConstructor(new Class[0]);
                return (CpuLoadMetric)cpuLoadMetricConstructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("Unknown CpuLoadMetric : {}", (Object)classToLoad);
                return CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC;
            }
        }
        catch (ReflectiveOperationException e) {
            this.logger.warn("Error creating CpuLoadMetric [" + classToLoad + "]");
            return CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC;
        }
    }
}

