/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.MessageFormatUtils;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.grpc.trace.PSpanMessage;
import com.navercorp.pinpoint.grpc.trace.SpanGrpc;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.sender.grpc.ClientStreamingService;
import com.navercorp.pinpoint.profiler.sender.grpc.GrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.MessageDispatcher;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.profiler.sender.grpc.ResponseStreamObserver;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamState;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamTask;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.ClientStreamingProvider;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.DefaultStreamTask;
import com.navercorp.pinpoint.profiler.sender.grpc.stream.StreamExecutorFactory;
import com.navercorp.pinpoint.profiler.util.NamedRunnable;
import io.github.resilience4j.core.IntervalFunction;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.stub.ClientCallStreamObserver;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class SpanGrpcDataSender
extends GrpcDataSender<SpanType> {
    private final ReconnectExecutor reconnectExecutor;
    private final Reconnector reconnector;
    private final StreamState failState;
    private final StreamExecutorFactory<PSpanMessage> streamExecutorFactory;
    private final String id = "SpanStream";
    private volatile StreamTask<SpanType, PSpanMessage> currentStreamTask;
    private final ClientStreamingService<PSpanMessage, Empty> clientStreamService;
    private final IntervalFunction interval;
    private final AtomicLong rpcExpiredAt;
    public final MessageDispatcher<SpanType, PSpanMessage> dispatcher = new MessageDispatcher<SpanType, PSpanMessage>(){

        @Override
        public void onDispatch(ClientCallStreamObserver<PSpanMessage> stream, SpanType data) {
            GeneratedMessageV3 message = (GeneratedMessageV3)SpanGrpcDataSender.this.messageConverter.toMessage((Object)data);
            if (SpanGrpcDataSender.this.isDebug) {
                SpanGrpcDataSender.this.logger.debug("Send message={}", (Object)MessageFormatUtils.debugLog((GeneratedMessageV3)message));
            }
            if (message instanceof PSpanChunk) {
                PSpanChunk spanChunk = (PSpanChunk)message;
                PSpanMessage spanMessage = PSpanMessage.newBuilder().setSpanChunk(spanChunk).build();
                stream.onNext((Object)spanMessage);
                SpanGrpcDataSender.this.attemptRenew();
                return;
            }
            if (message instanceof PSpan) {
                PSpan pSpan = (PSpan)message;
                PSpanMessage spanMessage = PSpanMessage.newBuilder().setSpan(pSpan).build();
                stream.onNext((Object)spanMessage);
                SpanGrpcDataSender.this.attemptRenew();
                return;
            }
            throw new IllegalStateException("unsupported message " + data);
        }
    };

    public SpanGrpcDataSender(String host, int port, int executorQueueSize, MessageConverter<SpanType, GeneratedMessageV3> messageConverter, ReconnectExecutor reconnectExecutor, ChannelFactory channelFactory, StreamState failState, long maxRpcAgeMillis) {
        super(host, port, executorQueueSize, messageConverter, channelFactory);
        this.interval = this.newIntervalFunction(maxRpcAgeMillis);
        this.rpcExpiredAt = new AtomicLong(System.currentTimeMillis());
        this.reconnectExecutor = Objects.requireNonNull(reconnectExecutor, "reconnectExecutor");
        NamedRunnable reconnectJob = new NamedRunnable(this.id){

            @Override
            public void run() {
                SpanGrpcDataSender.this.startStream();
            }
        };
        this.reconnector = reconnectExecutor.newReconnector(reconnectJob);
        this.failState = Objects.requireNonNull(failState, "failState");
        this.streamExecutorFactory = new StreamExecutorFactory(this.executor);
        ClientStreamingProvider<PSpanMessage, Empty> clientStreamProvider = new ClientStreamingProvider<PSpanMessage, Empty>(){

            @Override
            public ClientCallStreamObserver<PSpanMessage> newStream(ResponseStreamObserver<PSpanMessage, Empty> response) {
                ManagedChannel managedChannel = SpanGrpcDataSender.this.managedChannel;
                String authority = managedChannel.authority();
                ConnectivityState state = managedChannel.getState(false);
                SpanGrpcDataSender.this.logger.info("newStream {}/{} state:{} isShutdown:{} isTerminated:{}", (Object)"SpanStream", (Object)authority, (Object)state, (Object)managedChannel.isShutdown(), (Object)managedChannel.isTerminated());
                SpanGrpc.SpanStub spanStub = SpanGrpc.newStub((Channel)managedChannel);
                return (ClientCallStreamObserver)spanStub.sendSpan(response);
            }
        };
        this.clientStreamService = new ClientStreamingService<PSpanMessage, Empty>(clientStreamProvider, this.reconnector);
        reconnectJob.run();
    }

    private IntervalFunction newIntervalFunction(long maxRpcAgeMillis) {
        if (maxRpcAgeMillis >= 3153600000000L) {
            return null;
        }
        return IntervalFunction.ofRandomized((long)maxRpcAgeMillis, (double)0.1);
    }

    private void attemptRenew() {
        long nextRpcExpiredAt;
        if (this.interval == null) {
            return;
        }
        long rpcExpiredAtValue = this.rpcExpiredAt.get();
        long now = System.currentTimeMillis();
        if (now > rpcExpiredAtValue && this.rpcExpiredAt.compareAndSet(rpcExpiredAtValue, nextRpcExpiredAt = now + (Long)this.interval.apply((Object)1))) {
            if (this.isDebug) {
                this.logger.debug("renewStream nextRpcExpiredAt:{}", (Object)new Date(nextRpcExpiredAt));
            }
            this.renewStream();
        }
    }

    private void renewStream() {
        this.logger.debug("renewStream {}", (Object)this.name);
        if (this.currentStreamTask != null) {
            this.logger.info("Aborting Span RPC to renew");
            this.currentStreamTask.stop();
        }
    }

    private void startStream() {
        try {
            DefaultStreamTask<SpanType, PSpanMessage, Empty> streamTask = new DefaultStreamTask<SpanType, PSpanMessage, Empty>("SpanStream", this.clientStreamService, this.streamExecutorFactory, this.queue, this.dispatcher, this.failState);
            streamTask.start();
            this.currentStreamTask = streamTask;
        }
        catch (Throwable th) {
            this.logger.error("startStream error", th);
        }
    }

    public void stop() {
        StreamTask<SpanType, PSpanMessage> currentStreamTask;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.logger.info("Stop {}, channel={}", (Object)this.name, (Object)this.managedChannel);
        ReconnectExecutor reconnectExecutor = this.reconnectExecutor;
        if (reconnectExecutor != null) {
            reconnectExecutor.close();
        }
        if ((currentStreamTask = this.currentStreamTask) != null) {
            currentStreamTask.stop();
        }
        this.logger.info("{} close()", (Object)"SpanStream");
        this.release();
    }

    public String toString() {
        return "SpanGrpcDataSender{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + "} " + super.toString();
    }
}

