/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty.handler;

import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningMonitor;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningMonitors;
import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.server.embedded.CanalServerWithEmbedded;
import com.alibaba.otter.canal.server.netty.NettyUtils;
import com.alibaba.otter.canal.server.netty.handler.HandshakeInitializationHandler;
import com.alibaba.otter.canal.server.netty.handler.SessionHandler;
import com.google.protobuf.ByteString;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.helpers.MessageFormatter;

public class ClientAuthenticationHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientAuthenticationHandler.class);
    private final int SUPPORTED_VERSION = 3;
    private final int defaultSubscriptorDisconnectIdleTimeout = 3600000;
    private CanalServerWithEmbedded embeddedServer;
    private byte[] seed;

    public ClientAuthenticationHandler() {
    }

    public ClientAuthenticationHandler(CanalServerWithEmbedded embeddedServer) {
        this.embeddedServer = embeddedServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        byte[] errorBytes;
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        CanalPacket.Packet packet = CanalPacket.Packet.parseFrom((byte[])buffer.readBytes(buffer.readableBytes()).array());
        switch (packet.getVersion()) {
            default: 
        }
        CanalPacket.ClientAuth clientAuth = CanalPacket.ClientAuth.parseFrom((ByteString)packet.getBody());
        if (this.seed == null) {
            errorBytes = NettyUtils.errorPacket(400, MessageFormatter.format((String)"auth failed for seed is null", (Object)clientAuth.getUsername()).getMessage());
            NettyUtils.write(ctx.getChannel(), errorBytes, null);
        }
        if (!this.embeddedServer.auth(clientAuth.getUsername(), clientAuth.getPassword().toStringUtf8(), this.seed)) {
            errorBytes = NettyUtils.errorPacket(400, MessageFormatter.format((String)"auth failed for user:{}", (Object)clientAuth.getUsername()).getMessage());
            NettyUtils.write(ctx.getChannel(), errorBytes, null);
        }
        if (StringUtils.isNotEmpty((String)clientAuth.getDestination()) && StringUtils.isNotEmpty((String)clientAuth.getClientId())) {
            ClientIdentity clientIdentity = new ClientIdentity(clientAuth.getDestination(), Short.valueOf(clientAuth.getClientId()).shortValue(), clientAuth.getFilter());
            try {
                ServerRunningMonitor runningMonitor;
                MDC.put((String)"destination", (String)clientIdentity.getDestination());
                this.embeddedServer.subscribe(clientIdentity);
                if (!this.embeddedServer.isStart(clientIdentity.getDestination()) && !(runningMonitor = ServerRunningMonitors.getRunningMonitor((String)clientIdentity.getDestination())).isStart()) {
                    runningMonitor.start();
                }
            }
            finally {
                MDC.remove((String)"destination");
            }
        }
        NettyUtils.ack(ctx.getChannel(), future -> {
            logger.info("remove unused channel handlers after authentication is done successfully.");
            ctx.getPipeline().remove(HandshakeInitializationHandler.class.getName());
            ctx.getPipeline().remove(ClientAuthenticationHandler.class.getName());
            int readTimeout = 3600000;
            int writeTimeout = 3600000;
            if (clientAuth.getNetReadTimeout() > 0) {
                readTimeout = clientAuth.getNetReadTimeout();
            }
            if (clientAuth.getNetWriteTimeout() > 0) {
                writeTimeout = clientAuth.getNetWriteTimeout();
            }
            IdleStateHandler idleStateHandler = new IdleStateHandler(NettyUtils.hashedWheelTimer, (long)readTimeout, (long)writeTimeout, 0L, TimeUnit.MILLISECONDS);
            ctx.getPipeline().addBefore(SessionHandler.class.getName(), IdleStateHandler.class.getName(), (ChannelHandler)idleStateHandler);
            IdleStateAwareChannelHandler idleStateAwareChannelHandler = new IdleStateAwareChannelHandler(){

                public void channelIdle(ChannelHandlerContext ctx1, IdleStateEvent e1) throws Exception {
                    logger.warn("channel:{} idle timeout exceeds, close channel to save server resources...", (Object)ctx1.getChannel());
                    ctx1.getChannel().close();
                }
            };
            ctx.getPipeline().addBefore(SessionHandler.class.getName(), IdleStateAwareChannelHandler.class.getName(), (ChannelHandler)idleStateAwareChannelHandler);
        });
    }

    public void setEmbeddedServer(CanalServerWithEmbedded embeddedServer) {
        this.embeddedServer = embeddedServer;
    }

    public void setSeed(byte[] seed) {
        this.seed = seed;
    }
}

