/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.client;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;

public class PravegaEvent
implements Serializable {
    private static final long serialVersionUID = 0L;
    private SpecVersion version;
    private String topic;
    private String data;
    private Map<String, String> extensions = new HashMap<String, String>();
    private long createTimestamp;

    public static byte[] toByteArray(PravegaEvent pravegaEvent) {
        return JsonUtils.toJSONString((Object)pravegaEvent).getBytes(StandardCharsets.UTF_8);
    }

    public static PravegaEvent getFromByteArray(byte[] body) {
        return (PravegaEvent)JsonUtils.parseObject((String)new String(body, StandardCharsets.UTF_8), PravegaEvent.class);
    }

    public CloudEvent convertToCloudEvent() {
        CloudEventBuilder builder = CloudEventBuilder.fromSpecVersion((SpecVersion)this.version);
        builder.withData(this.data.getBytes(StandardCharsets.UTF_8)).withId(this.extensions.remove("id")).withSource(URI.create(this.extensions.remove("source"))).withType(this.extensions.remove("type")).withDataContentType(this.extensions.remove("datacontenttype")).withSubject(this.extensions.remove("subject"));
        this.extensions.forEach((arg_0, arg_1) -> ((CloudEventBuilder)builder).withExtension(arg_0, arg_1));
        return builder.build();
    }

    @Generated
    public SpecVersion getVersion() {
        return this.version;
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    @Generated
    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public void setVersion(SpecVersion version) {
        this.version = version;
    }

    @Generated
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    @Generated
    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PravegaEvent)) {
            return false;
        }
        PravegaEvent other = (PravegaEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTimestamp() != other.getCreateTimestamp()) {
            return false;
        }
        SpecVersion this$version = this.getVersion();
        SpecVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, String> this$extensions = this.getExtensions();
        Map<String, String> other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PravegaEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTimestamp = this.getCreateTimestamp();
        result = result * 59 + (int)($createTimestamp >>> 32 ^ $createTimestamp);
        SpecVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PravegaEvent(version=" + this.getVersion() + ", topic=" + this.getTopic() + ", data=" + this.getData() + ", extensions=" + this.getExtensions() + ", createTimestamp=" + this.getCreateTimestamp() + ")";
    }

    @Generated
    public PravegaEvent() {
    }
}

