/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.grpc.common.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookTopicConfig
extends ConsumerGroupTopicConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebhookTopicConfig.class);
    private final Map<String, List<String>> idcUrls = new ConcurrentHashMap<String, List<String>>();
    private List<String> totalUrls = new LinkedList<String>();

    public WebhookTopicConfig(String consumerGroup, String topic, SubscriptionMode subscriptionMode) {
        super(consumerGroup, topic, subscriptionMode, GrpcType.WEBHOOK);
    }

    @Override
    public synchronized void registerClient(ConsumerGroupClient client) {
        if (client.getGrpcType() != this.grpcType) {
            log.warn("Invalid grpc type: {}, expecting grpc type: {}, can not register client {}", new Object[]{client.getGrpcType(), this.grpcType, client.toString()});
            return;
        }
        String idc = client.getIdc();
        String url = client.getUrl();
        List urls = this.idcUrls.computeIfAbsent(idc, k -> new LinkedList());
        if (!urls.contains(url)) {
            urls.add(url);
        }
        this.totalUrls = this.buildTotalUrls();
    }

    @Override
    public void deregisterClient(ConsumerGroupClient client) {
        String idc = client.getIdc();
        String url = client.getUrl();
        List<String> urls = this.idcUrls.get(idc);
        if (urls == null) {
            return;
        }
        urls.remove(url);
        if (urls.isEmpty()) {
            this.idcUrls.remove(idc);
        }
        this.totalUrls = this.buildTotalUrls();
    }

    @Override
    public int getSize() {
        return this.totalUrls.size();
    }

    public String toString() {
        return "WebhookConsumeTopicConfig={consumerGroup=" + this.consumerGroup + ",grpcType=" + this.grpcType + ",topic=" + this.topic + ",idcUrls=" + this.idcUrls + "}";
    }

    @Override
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    @Override
    public GrpcType getGrpcType() {
        return this.grpcType;
    }

    public Map<String, List<String>> getIdcUrls() {
        return this.idcUrls;
    }

    private List<String> buildTotalUrls() {
        HashSet<String> totalUrls = new HashSet<String>();
        for (List<String> idcUrls : this.idcUrls.values()) {
            totalUrls.addAll(idcUrls);
        }
        return new ArrayList<String>(totalUrls);
    }

    public List<String> getTotalUrls() {
        return this.totalUrls;
    }
}

