/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.async;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;

public class AsyncContext<T> {
    private T request;
    private T response;
    private volatile boolean complete = Boolean.FALSE;
    private ThreadPoolExecutor asyncContextExecutor;

    public AsyncContext(T request, T response, ThreadPoolExecutor asyncContextExecutor) {
        Preconditions.checkState((request != null ? 1 : 0) != 0, (Object)"create async context err because of request is null");
        this.request = request;
        this.response = response;
        this.asyncContextExecutor = asyncContextExecutor;
    }

    public void onComplete(T response) {
        Preconditions.checkState((boolean)Objects.nonNull(response), (Object)"response cant be null");
        this.response = response;
        this.complete = Boolean.TRUE;
    }

    public void onComplete(T response, CompleteHandler<T> handler) {
        Preconditions.checkState((boolean)Objects.nonNull(response), (Object)"response cant be null");
        Preconditions.checkState((boolean)Objects.nonNull(handler), (Object)"handler cant be null");
        this.response = response;
        CompletableFuture.runAsync(() -> handler.onResponse(response), this.asyncContextExecutor);
        this.complete = Boolean.TRUE;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }

    public T getResponse() {
        return this.response;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public ThreadPoolExecutor getAsyncContextExecutor() {
        return this.asyncContextExecutor;
    }

    public void setAsyncContextExecutor(ThreadPoolExecutor asyncContextExecutor) {
        this.asyncContextExecutor = asyncContextExecutor;
    }
}

