/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.tcp;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.eventmesh.common.enums.ProtocolType;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.metrics.MetricsManager;
import org.apache.eventmesh.runtime.metrics.MetricsUtils;
import org.apache.eventmesh.runtime.metrics.tcp.TcpMetrics;
import org.apache.eventmesh.runtime.metrics.tcp.TcpMetricsCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpMetricsManager
implements MetricsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshTcpMetricsManager.class);
    private final Map<String, String> labelMap = new HashMap<String, String>();
    private final EventMeshTCPServer eventMeshTCPServer;
    private final TcpMetrics tcpMetrics;
    private final List<MetricsRegistry> metricsRegistries;
    private final TcpMetricsCalculator calculator;

    public EventMeshTcpMetricsManager(EventMeshTCPServer eventMeshTCPServer, List<MetricsRegistry> metricsRegistries) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.init();
        this.tcpMetrics = new TcpMetrics(eventMeshTCPServer, this.labelMap);
        this.metricsRegistries = (List)Preconditions.checkNotNull(metricsRegistries);
        this.calculator = new TcpMetricsCalculator(eventMeshTCPServer, this.tcpMetrics);
    }

    private void init() {
        String eventMeshServerIp = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshServerIp();
        int eventMeshTcpServerPort = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshTcpServerPort();
        this.labelMap.put("net.host.name", Optional.ofNullable(eventMeshServerIp).orElse(IPUtils.getLocalAddress()));
        this.labelMap.put("net.host.port", Integer.toString(eventMeshTcpServerPort));
        this.labelMap.put("rpc.system", "TCP");
        this.labelMap.put("rpc.service", this.eventMeshTCPServer.getClass().getName());
        log.info("EventMeshTcpMetricsManager initialized......");
    }

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    @Override
    public void start() {
        this.calculator.start();
        log.info("EventMeshTcpMetricsManager started......");
    }

    public void client2eventMeshMsgNumIncrement(String clientAddress) {
        this.tcpMetrics.getClient2eventMeshMsgNum().getAndIncrement();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.TCP.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementClientToEventMeshMsgNum(attributes);
    }

    public void eventMesh2mqMsgNumIncrement() {
        this.tcpMetrics.getEventMesh2mqMsgNum().getAndIncrement();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        MetricsUtils.incrementEventMeshToMQMsgNum(attributes);
    }

    public void mq2eventMeshMsgNumIncrement() {
        this.tcpMetrics.getMq2eventMeshMsgNum().getAndIncrement();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        MetricsUtils.incrementMQToEventMeshMsgNum(attributes);
    }

    public void eventMesh2clientMsgNumIncrement(String clientAddress) {
        this.tcpMetrics.getEventMesh2clientMsgNum().getAndIncrement();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.TCP.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementEventMeshToClientMsgNum(attributes);
    }

    public TcpMetrics getTcpMetrics() {
        return this.tcpMetrics;
    }

    @Override
    public void shutdown() {
        this.calculator.shutdown();
        log.info("EventMeshTcpMetricsManager shutdown......");
    }

    @Override
    public List<Metric> getMetrics() {
        return new ArrayList<Metric>(this.tcpMetrics.getMetrics());
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

