/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.lang3.ArrayUtils;

public abstract class RemotingHelper {
    public static String exceptionSimpleDesc(Throwable e) {
        StringBuilder sb = new StringBuilder();
        if (e != null) {
            sb.append(e);
            Object[] stackTrace = e.getStackTrace();
            if (ArrayUtils.isNotEmpty((Object[])stackTrace)) {
                sb.append(", ").append(stackTrace[0]);
            }
        }
        return sb.toString();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        int split = addr.lastIndexOf(58);
        String host = addr.substring(0, split);
        String port = addr.substring(split + 1);
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (channel == null) {
            return "";
        }
        String string = addr = channel.remoteAddress() != null ? channel.remoteAddress().toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf(47);
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseChannelLocalAddr(Channel channel) {
        String addr;
        if (channel == null) {
            return "";
        }
        String string = addr = channel.localAddress() != null ? channel.localAddress().toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf(47);
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseSocketAddressAddr(InetSocketAddress socketAddress) {
        return socketAddress != null ? socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort() : "";
    }
}

