/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.notifications.notifier;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.notifications.Listener;
import io.pravega.client.stream.notifications.Notification;
import io.pravega.client.stream.notifications.NotificationSystem;
import io.pravega.client.stream.notifications.notifier.AbstractNotifier;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPollingNotifier<T extends Notification>
extends AbstractNotifier<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPollingNotifier.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    final StateSynchronizer<ReaderGroupState> synchronizer;
    @GuardedBy(value="$lock")
    private ScheduledFuture<?> pollingTaskFuture;
    private final AtomicBoolean pollingStarted = new AtomicBoolean();

    AbstractPollingNotifier(NotificationSystem notifySystem, ScheduledExecutorService executor, StateSynchronizer<ReaderGroupState> synchronizer) {
        super(notifySystem, executor);
        this.synchronizer = synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(Listener<T> listener) {
        Object object = this.$lock;
        synchronized (object) {
            super.unregisterListener(listener);
            if (!this.notifySystem.isListenerPresent(this.getType())) {
                this.cancelScheduledTask();
                this.synchronizer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAllListeners() {
        Object object = this.$lock;
        synchronized (object) {
            super.unregisterAllListeners();
            this.cancelScheduledTask();
            this.synchronizer.close();
        }
    }

    void cancelScheduledTask() {
        log.debug("Cancel the scheduled task to check");
        if (this.pollingTaskFuture != null) {
            this.pollingTaskFuture.cancel(true);
        }
        this.pollingStarted.set(false);
    }

    void startPolling(Runnable pollingTask, int pollingIntervalSeconds) {
        if (!this.pollingStarted.getAndSet(true)) {
            this.pollingTaskFuture = this.executor.scheduleAtFixedRate(pollingTask, 0L, pollingIntervalSeconds, TimeUnit.SECONDS);
        }
    }
}

