/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server.flowcontrol;

import com.navercorp.pinpoint.grpc.server.flowcontrol.RejectedExecutionListener;
import com.navercorp.pinpoint.grpc.server.flowcontrol.RejectedExecutionListenerFactory;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ScheduledExecutor;
import com.navercorp.pinpoint.grpc.server.flowcontrol.ServerCallWrapper;
import java.util.Objects;
import java.util.concurrent.Future;

public class StreamExecutorRejectedExecutionRequestScheduler {
    private final ScheduledExecutor scheduledExecutor;
    private final RejectedExecutionListenerFactory rejectedExecutionListenerFactory;

    public StreamExecutorRejectedExecutionRequestScheduler(ScheduledExecutor scheduledExecutor, RejectedExecutionListenerFactory rejectedExecutionListenerFactory) {
        this.scheduledExecutor = Objects.requireNonNull(scheduledExecutor, "scheduledExecutor");
        this.rejectedExecutionListenerFactory = Objects.requireNonNull(rejectedExecutionListenerFactory, "rejectedExecutionListenerFactory");
    }

    public Listener schedule(ServerCallWrapper serverCall) {
        RejectedExecutionListener rejectedExecutionListener = this.rejectedExecutionListenerFactory.newListener(serverCall);
        RequestScheduleJob command = new RequestScheduleJob(rejectedExecutionListener);
        Future<?> future = this.scheduledExecutor.schedule(command);
        rejectedExecutionListener.setFuture(future);
        return new Listener(rejectedExecutionListener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamExecutorRejectedExecutionRequestScheduler{");
        sb.append("scheduledExecutorService=").append(this.scheduledExecutor);
        sb.append(", rejectedExecutionListenerFactory=").append(this.rejectedExecutionListenerFactory);
        sb.append('}');
        return sb.toString();
    }

    public static class Listener {
        private final RejectedExecutionListener rejectedExecutionListener;

        public Listener(RejectedExecutionListener rejectedExecutionListener) {
            this.rejectedExecutionListener = Objects.requireNonNull(rejectedExecutionListener, "rejectedExecutionListener");
        }

        public void onRejectedExecution() {
            this.rejectedExecutionListener.onRejectedExecution();
        }

        public void onCancel() {
            this.rejectedExecutionListener.cancel();
        }

        public long getRejectedExecutionCount() {
            return this.rejectedExecutionListener.getRejectedExecutionCount();
        }

        public boolean isCancelled() {
            return this.rejectedExecutionListener.isCancelled();
        }

        public void onMessage() {
            this.rejectedExecutionListener.onMessage();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Listener{");
            sb.append("rejectedExecutionListener=").append(this.rejectedExecutionListener);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class RequestScheduleJob
    implements Runnable {
        private final RejectedExecutionListener rejectedExecutionListener;

        public RequestScheduleJob(RejectedExecutionListener rejectedExecutionListener) {
            this.rejectedExecutionListener = Objects.requireNonNull(rejectedExecutionListener, "rejectedExecutionListener");
        }

        @Override
        public void run() {
            this.rejectedExecutionListener.onSchedule();
        }

        public RejectedExecutionListener getRejectedExecutionListener() {
            return this.rejectedExecutionListener;
        }
    }
}

