/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.spring.source.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.spring.SpringSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.spring.SpringRecordOffset;
import org.apache.eventmesh.common.remote.offset.spring.SpringRecordPartition;
import org.apache.eventmesh.connector.spring.source.MessageSendingOperations;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendMessageCallback;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SpringSourceConnector
implements Source,
MessageSendingOperations,
ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringSourceConnector.class);
    private static final String CONNECTOR_PROPERTY_PREFIX = "eventmesh.connector.";
    private ApplicationContext applicationContext;
    private SpringSourceConfig sourceConfig;
    private BlockingQueue<ConnectRecord> queue;
    private int maxBatchSize;
    private long maxPollWaitTime;

    public Class<? extends Config> configClass() {
        return SpringSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (SpringSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (SpringSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        this.queue = new LinkedBlockingQueue<ConnectRecord>(this.sourceConfig.getPollConfig().getCapacity());
        this.maxBatchSize = this.sourceConfig.getPollConfig().getMaxBatchSize();
        this.maxPollWaitTime = this.sourceConfig.getPollConfig().getMaxWaitTime();
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getSourceConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = this.maxPollWaitTime;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.maxBatchSize);
        for (int count = 0; count < this.maxBatchSize; ++count) {
            try {
                ConnectRecord connectRecord = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (connectRecord == null) break;
                connectRecords.add(connectRecord);
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = this.maxPollWaitTime > elapsedTime ? this.maxPollWaitTime - elapsedTime : 0L;
                continue;
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[SpringSourceConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
        }
        return connectRecords;
    }

    @Override
    public void send(Object message) {
        SpringRecordPartition partition = new SpringRecordPartition();
        SpringRecordOffset offset = new SpringRecordOffset();
        ConnectRecord record = new ConnectRecord((RecordPartition)partition, (RecordOffset)offset, Long.valueOf(System.currentTimeMillis()), message);
        this.addSpringEnvironmentPropertyExtensions(record);
        this.queue.offer(record);
    }

    @Override
    public void send(Object message, SendMessageCallback workerCallback) {
        SpringRecordPartition partition = new SpringRecordPartition();
        SpringRecordOffset offset = new SpringRecordOffset();
        ConnectRecord record = new ConnectRecord((RecordPartition)partition, (RecordOffset)offset, Long.valueOf(System.currentTimeMillis()), message);
        record.addExtension("callBackExtension", (Object)workerCallback);
        this.addSpringEnvironmentPropertyExtensions(record);
        this.queue.offer(record);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void addSpringEnvironmentPropertyExtensions(ConnectRecord connectRecord) {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.applicationContext;
        MutablePropertySources propertySources = context.getEnvironment().getPropertySources();
        for (PropertySource propertySource : propertySources) {
            String[] keys;
            if (!(propertySource instanceof OriginTrackedMapPropertySource)) continue;
            OriginTrackedMapPropertySource originTrackedMapPropertySource = (OriginTrackedMapPropertySource)propertySource;
            for (String key : keys = originTrackedMapPropertySource.getPropertyNames()) {
                if (!key.startsWith(CONNECTOR_PROPERTY_PREFIX)) continue;
                Object value = null;
                try {
                    value = originTrackedMapPropertySource.getProperty(key);
                    if (value == null) continue;
                    connectRecord.addExtension(key.replaceAll(CONNECTOR_PROPERTY_PREFIX, "").toLowerCase(), (Object)String.valueOf(value));
                }
                catch (Throwable e) {
                    log.error("Put spring environment property to extension failed, key=[{}], value=[{}]", (Object)key, value);
                }
            }
        }
    }
}

