/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.theokanning.openai.completion.chat.ChatFunctionParameters;
import com.theokanning.openai.completion.chat.ChatFunctionProperty;
import lombok.NonNull;

public class ChatFunctionDynamic {
    @NonNull
    private String name;
    private String description;
    private ChatFunctionParameters parameters;

    public static Builder builder() {
        return new Builder();
    }

    public ChatFunctionDynamic(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ChatFunctionParameters getParameters() {
        return this.parameters;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParameters(ChatFunctionParameters parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatFunctionDynamic)) {
            return false;
        }
        ChatFunctionDynamic other = (ChatFunctionDynamic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ChatFunctionParameters this$parameters = this.getParameters();
        ChatFunctionParameters other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatFunctionDynamic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ChatFunctionParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "ChatFunctionDynamic(name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
    }

    public static class Builder {
        private String name;
        private String description;
        private ChatFunctionParameters parameters = new ChatFunctionParameters();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(ChatFunctionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addProperty(ChatFunctionProperty property) {
            this.parameters.addProperty(property);
            return this;
        }

        public ChatFunctionDynamic build() {
            ChatFunctionDynamic chatFunction = new ChatFunctionDynamic(this.name);
            chatFunction.setDescription(this.description);
            chatFunction.setParameters(this.parameters);
            return chatFunction;
        }
    }
}

