/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlConnector;
import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.QueryCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.EOFPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ErrorPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.FieldPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetHeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.RowDataPacket;
import com.alibaba.otter.canal.parse.driver.mysql.socket.SocketChannel;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MysqlQueryExecutor {
    private SocketChannel channel;

    public MysqlQueryExecutor(MysqlConnector connector) throws IOException {
        if (!connector.isConnected()) {
            throw new IOException("should execute connector.connect() first");
        }
        this.channel = connector.getChannel();
    }

    public MysqlQueryExecutor(SocketChannel ch) {
        this.channel = ch;
    }

    public ResultSetPacket query(String queryString) throws IOException {
        QueryCommandPacket cmd = new QueryCommandPacket();
        cmd.setQueryString(queryString);
        byte[] bodyBytes = cmd.toBytes();
        PacketManager.writeBody(this.channel, bodyBytes);
        byte[] body = this.readNextPacket();
        if (body[0] < 0) {
            ErrorPacket packet = new ErrorPacket();
            packet.fromBytes(body);
            throw new IOException(packet + "\n with command: " + queryString);
        }
        ResultSetHeaderPacket rsHeader = new ResultSetHeaderPacket();
        rsHeader.fromBytes(body);
        ArrayList<FieldPacket> fields = new ArrayList<FieldPacket>();
        int i = 0;
        while ((long)i < rsHeader.getColumnCount()) {
            FieldPacket fp = new FieldPacket();
            fp.fromBytes(this.readNextPacket());
            fields.add(fp);
            ++i;
        }
        this.readEofPacket();
        ArrayList<RowDataPacket> rowData = new ArrayList<RowDataPacket>();
        while ((body = this.readNextPacket())[0] != -2) {
            RowDataPacket rowDataPacket = new RowDataPacket();
            rowDataPacket.fromBytes(body);
            rowData.add(rowDataPacket);
        }
        ResultSetPacket resultSet = new ResultSetPacket();
        resultSet.getFieldDescriptors().addAll(fields);
        for (RowDataPacket r : rowData) {
            resultSet.getFieldValues().addAll(r.getColumns());
        }
        resultSet.setSourceAddress(this.channel.getRemoteSocketAddress());
        return resultSet;
    }

    public List<ResultSetPacket> queryMulti(String queryString) throws IOException {
        QueryCommandPacket cmd = new QueryCommandPacket();
        cmd.setQueryString(queryString);
        byte[] bodyBytes = cmd.toBytes();
        PacketManager.writeBody(this.channel, bodyBytes);
        ArrayList<ResultSetPacket> resultSets = new ArrayList<ResultSetPacket>();
        boolean moreResult = true;
        while (moreResult) {
            byte[] body = this.readNextPacket();
            if (body[0] < 0) {
                ErrorPacket packet = new ErrorPacket();
                packet.fromBytes(body);
                throw new IOException(packet + "\n with command: " + queryString);
            }
            ResultSetHeaderPacket rsHeader = new ResultSetHeaderPacket();
            rsHeader.fromBytes(body);
            ArrayList<FieldPacket> fields = new ArrayList<FieldPacket>();
            int i = 0;
            while ((long)i < rsHeader.getColumnCount()) {
                FieldPacket fp = new FieldPacket();
                fp.fromBytes(this.readNextPacket());
                fields.add(fp);
                ++i;
            }
            this.readEofPacket();
            ArrayList<RowDataPacket> rowData = new ArrayList<RowDataPacket>();
            while (true) {
                if ((body = this.readNextPacket())[0] == -2) break;
                RowDataPacket rowDataPacket = new RowDataPacket();
                rowDataPacket.fromBytes(body);
                rowData.add(rowDataPacket);
            }
            EOFPacket packet = this.parseEOFPacket(body);
            moreResult = (packet.statusFlag & 8) != 0;
            ResultSetPacket resultSet = new ResultSetPacket();
            resultSet.getFieldDescriptors().addAll(fields);
            for (RowDataPacket r : rowData) {
                resultSet.getFieldValues().addAll(r.getColumns());
            }
            resultSet.setSourceAddress(this.channel.getRemoteSocketAddress());
            resultSets.add(resultSet);
        }
        return resultSets;
    }

    private boolean readEofPacket() throws IOException {
        byte[] eofBody = this.readNextPacket();
        EOFPacket packet = this.parseEOFPacket(eofBody);
        return (packet.statusFlag & 8) != 0;
    }

    private EOFPacket parseEOFPacket(byte[] eofBody) throws IOException {
        EOFPacket packet = new EOFPacket();
        packet.fromBytes(eofBody);
        if (eofBody[0] != -2) {
            throw new IOException("EOF Packet is expected, but packet with field_count=" + eofBody[0] + " is found.");
        }
        return packet;
    }

    protected byte[] readNextPacket() throws IOException {
        HeaderPacket h = PacketManager.readHeader(this.channel, 4);
        return PacketManager.readBytes(this.channel, h.getPacketBodyLength());
    }
}

