/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.client;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.EventMeshGrpcProducer;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventsPublishInstance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudEventsPublishInstance.class);
    public static final int MESSAGE_SIZE = 5;

    public static void main(String[] args) throws Exception {
        try (EventMeshGrpcProducer eventMeshGrpcProducer = new EventMeshGrpcProducer(CloudEventsPublishInstance.initEventMeshGrpcClientConfig("FUNCTION_PRODUCER_GROUP"));){
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("content", "testAsyncMessage");
            for (int i = 0; i < 5; ++i) {
                eventMeshGrpcProducer.publish((Object)CloudEventsPublishInstance.buildCloudEvent(content));
                ThreadUtils.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            ThreadUtils.sleep((long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected static EventMeshGrpcClientConfig initEventMeshGrpcClientConfig(String groupName) throws IOException {
        String eventMeshIp = "127.0.0.1";
        String eventMeshGrpcPort = "10110";
        return EventMeshGrpcClientConfig.builder().serverAddr("127.0.0.1").serverPort(Integer.parseInt("10110")).producerGroup(groupName).env("env").idc("idc").sys("1234").build();
    }

    protected static CloudEvent buildCloudEvent(Map<String, String> content) {
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSubject("TEST-TOPIC-FUNCTION").withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType("cloudevents").withData(JsonUtils.toJSONString(content).getBytes(StandardCharsets.UTF_8))).withExtension("ttl", String.valueOf(4000))).build();
    }
}

