/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.redis.admin;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.eventmesh.api.admin.AbstractAdmin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.storage.redis.client.RedissonClient;
import org.redisson.Redisson;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RTopic;

public class RedisAdmin
extends AbstractAdmin {
    private final Redisson redisson = RedissonClient.INSTANCE;

    public RedisAdmin() {
        super(new AtomicBoolean(false));
    }

    public List<TopicProperties> getTopic() throws Exception {
        RPatternTopic patternTopic = this.redisson.getPatternTopic("*");
        return patternTopic.getPatternNames().stream().map(s -> new TopicProperties(s, 0L)).collect(Collectors.toList());
    }

    public void createTopic(String topicName) throws Exception {
    }

    public void deleteTopic(String topicName) throws Exception {
        RTopic topic = this.redisson.getTopic(topicName);
        topic.removeAllListeners();
    }

    public void publish(CloudEvent cloudEvent) throws Exception {
        RTopic topic = this.redisson.getTopic(cloudEvent.getSubject());
        topic.publish((Object)cloudEvent);
    }
}

