/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.MultiKeyLatestItemSequentialProcessor;
import io.pravega.shared.metrics.ClientMetricKeys;
import io.pravega.shared.metrics.MetricListener;
import io.pravega.shared.metrics.MetricNotifier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class ClientMetricUpdater
implements MetricNotifier {
    private final MultiKeyLatestItemSequentialProcessor<String, Long> successProcessor;
    private final MultiKeyLatestItemSequentialProcessor<String, Long> failureProcessor;
    private final ScheduledExecutorService clientMetricExecutor = ExecutorServiceHelpers.newScheduledThreadPool((int)1, (String)"clientMetrics");

    public ClientMetricUpdater(MetricListener metricListener) {
        Preconditions.checkNotNull((Object)metricListener);
        this.successProcessor = new MultiKeyLatestItemSequentialProcessor(metricListener::reportSuccessValue, (Executor)this.clientMetricExecutor);
        this.failureProcessor = new MultiKeyLatestItemSequentialProcessor(metricListener::reportFailValue, (Executor)this.clientMetricExecutor);
    }

    @Override
    public void updateSuccessMetric(ClientMetricKeys metricKey, String[] metricTags, long value) {
        this.successProcessor.updateItem((Object)metricKey.metric(metricTags), (Object)value);
    }

    @Override
    public void updateFailureMetric(ClientMetricKeys metricKey, String[] metric, long value) {
        this.failureProcessor.updateItem((Object)metricKey.metric(metric), (Object)value);
    }

    @Override
    public void close() {
        ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.clientMetricExecutor});
    }
}

