/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.api.RLock;
import org.redisson.api.RLockRx;
import org.redisson.api.RMap;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSemaphoreRx;
import org.redisson.rx.CommandRxExecutor;
import org.redisson.rx.RedissonMapRxIterator;
import org.redisson.rx.RxProxyBuilder;

public class RedissonMapRx<K, V> {
    private final RMap<K, V> instance;
    private final CommandRxExecutor executor;

    public RedissonMapRx(RMap<K, V> instance, CommandRxExecutor executor) {
        this.instance = instance;
        this.executor = executor;
    }

    public Publisher<Map.Entry<K, V>> entryIterator() {
        return this.entryIterator(null);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(int count) {
        return this.entryIterator(null, count);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern) {
        return this.entryIterator(pattern, 10);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return new RedissonMapRxIterator((RedissonMap)this.instance, pattern, count).create();
    }

    public Publisher<V> valueIterator() {
        return this.valueIterator(null);
    }

    public Publisher<V> valueIterator(String pattern) {
        return this.valueIterator(pattern, 10);
    }

    public Publisher<V> valueIterator(int count) {
        return this.valueIterator(null, count);
    }

    public Publisher<V> valueIterator(String pattern, int count) {
        return new RedissonMapRxIterator<K, V, V>((RedissonMap)this.instance, pattern, count){

            @Override
            V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        }.create();
    }

    public Publisher<K> keyIterator() {
        return this.keyIterator(null);
    }

    public Publisher<K> keyIterator(String pattern) {
        return this.keyIterator(pattern, 10);
    }

    public Publisher<K> keyIterator(int count) {
        return this.keyIterator(null, count);
    }

    public Publisher<K> keyIterator(String pattern, int count) {
        return new RedissonMapRxIterator<K, V, K>((RedissonMap)this.instance, pattern, count){

            @Override
            K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        }.create();
    }

    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(K key) {
        RPermitExpirableSemaphore s = this.instance.getPermitExpirableSemaphore(key);
        return RxProxyBuilder.create(this.executor, s, RPermitExpirableSemaphoreRx.class);
    }

    public RSemaphoreRx getSemaphore(K key) {
        RSemaphore s = this.instance.getSemaphore(key);
        return RxProxyBuilder.create(this.executor, s, RSemaphoreRx.class);
    }

    public RLockRx getFairLock(K key) {
        RLock lock = this.instance.getFairLock(key);
        return RxProxyBuilder.create(this.executor, lock, RLockRx.class);
    }

    public RReadWriteLockRx getReadWriteLock(K key) {
        RReadWriteLock lock = this.instance.getReadWriteLock(key);
        return RxProxyBuilder.create(this.executor, lock, RReadWriteLockRx.class);
    }

    public RLockRx getLock(K key) {
        RLock lock = this.instance.getLock(key);
        return RxProxyBuilder.create(this.executor, lock, RLockRx.class);
    }
}

