/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.portfolio.loanaccount.api.LoanChargesApiResource;
import org.springframework.stereotype.Component;

@Component
public class CollectChargesByLoanExternalIdCommandStrategy
implements CommandStrategy {
    private final LoanChargesApiResource loanChargesApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        String loanExternalId = (String)pathParameters.get(2);
        if (relativeUrl.indexOf(63) > 0) {
            Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            CommandStrategyUtils.addQueryParametersToUriInfo((MutableUriInfo)parameterizedUriInfo, (Map)queryParameters);
        }
        String responseBody = this.loanChargesApiResource.retrieveAllLoanCharges(loanExternalId, (UriInfo)parameterizedUriInfo);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public CollectChargesByLoanExternalIdCommandStrategy(LoanChargesApiResource loanChargesApiResource) {
        this.loanChargesApiResource = loanChargesApiResource;
    }
}

