/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config;

import java.security.SecureRandom;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.config.OkHttp3Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OkHttp3Config {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OkHttp3Config.class);
    private final FineractProperties fineractProperties;

    @Bean
    public OkHttpClient okHttpClient() throws Exception {
        OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(this.fineractProperties.getClientConnectTimeout())).readTimeout(Duration.ofSeconds(this.fineractProperties.getClientReadTimeout())).writeTimeout(Duration.ofSeconds(this.fineractProperties.getClientWriteTimeout()));
        if (Boolean.TRUE.equals(this.fineractProperties.getInsecureHttpClient())) {
            1 insecureX509TrustManager = new /* Unavailable Anonymous Inner Class!! */;
            SSLContext insecureSSLContext = SSLContext.getInstance("TLS");
            insecureSSLContext.init(null, new TrustManager[]{insecureX509TrustManager}, new SecureRandom());
            okBuilder.sslSocketFactory(insecureSSLContext.getSocketFactory(), (X509TrustManager)insecureX509TrustManager);
            HostnameVerifier insecureHostnameVerifier = (hostname, session) -> true;
            okBuilder.hostnameVerifier(insecureHostnameVerifier);
        }
        return okBuilder.build();
    }

    @Generated
    public OkHttp3Config(FineractProperties fineractProperties) {
        this.fineractProperties = fineractProperties;
    }
}

