/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.support;

import lombok.Generated;
import org.aopalliance.aop.Advice;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingConfiguration;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingService;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingServiceFactory;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.support.SamplingMethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class SamplingBeanPostProcessor
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamplingBeanPostProcessor.class);
    private SamplingConfiguration samplingConfiguration;
    private SamplingServiceFactory samplingServiceFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass;
        boolean isSamplingConfiguredForBean;
        if (this.isSamplingEnabled() && (isSamplingConfiguredForBean = this.samplingConfiguration.isSamplingConfiguredForClass(beanClass = AopProxyUtils.ultimateTargetClass((Object)bean)))) {
            log.info("Sampling is enabled for {}", (Object)beanClass);
            SamplingService samplingService = this.samplingServiceFactory.forClass(beanClass);
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setTarget(bean);
            proxyFactory.addAdvice((Advice)new SamplingMethodInterceptor(samplingService));
            return proxyFactory.getProxy();
        }
        return bean;
    }

    private boolean isSamplingEnabled() {
        return this.samplingConfiguration != null && this.samplingConfiguration.isSamplingEnabled();
    }

    @Autowired
    public void setSamplingServiceFactory(SamplingServiceFactory samplingServiceFactory) {
        this.samplingServiceFactory = samplingServiceFactory;
    }

    @Autowired
    public void setSamplingConfiguration(SamplingConfiguration samplingConfiguration) {
        this.samplingConfiguration = samplingConfiguration;
    }

    @Generated
    public SamplingBeanPostProcessor() {
    }
}

