/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.apache.fineract.infrastructure.core.jersey.serializer.JacksonDeserializerAdapter;
import org.apache.fineract.infrastructure.core.jersey.serializer.JacksonSerializerAdapter;
import org.apache.fineract.infrastructure.core.jersey.serializer.legacy.JacksonLocalDateArrayModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class JerseyJacksonConverterConfig {
    @Bean
    public ObjectMapper objectMapper(List<JsonSerializer<?>> serializers, List<JsonDeserializer<?>> deserializers, List<JsonConverter<?>> jsonConverters) {
        ArrayList mergedSerializers = new ArrayList(serializers);
        mergedSerializers.addAll(jsonConverters.stream().map(JacksonSerializerAdapter::new).toList());
        ArrayList mergedDeserializers = new ArrayList(deserializers);
        mergedDeserializers.addAll(jsonConverters.stream().map(JacksonDeserializerAdapter::new).toList());
        ObjectMapper objectMapper = new Jackson2ObjectMapperBuilder().serializers(mergedSerializers.toArray(new JsonSerializer[0])).serializationInclusion(JsonInclude.Include.NON_NULL).deserializers(mergedDeserializers.toArray(new JsonDeserializer[0])).featuresToDisable(new Object[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).featuresToEnable(new Object[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).build();
        objectMapper.registerModule((Module)new JacksonLocalDateArrayModule());
        return objectMapper;
    }
}

