/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauConfigurationData;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauData;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauLoanProductMappingData;
import org.apache.fineract.infrastructure.creditbureau.data.OrganisationCreditBureauData;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauLoanProductMappingReadPlatformService;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauReadConfigurationService;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauReadPlatformService;
import org.apache.fineract.infrastructure.creditbureau.service.OrganisationCreditBureauReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/CreditBureauConfiguration")
@Component
@Tag(name="Credit Bureau Configuration", description="")
public class CreditBureauConfigurationApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("creditBureauId", "alias", "country", "creditBureauProductId", "startDate", "endDate", "isActive"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CreditBureau";
    private final PlatformSecurityContext context;
    private final CreditBureauReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<CreditBureauData> toApiJsonSerializer;
    private final CreditBureauLoanProductMappingReadPlatformService readPlatformServiceCreditBureauLoanProduct;
    private final OrganisationCreditBureauReadPlatformService readPlatformServiceOrganisationCreditBureau;
    private final DefaultToApiJsonSerializer<CreditBureauLoanProductMappingData> toApiJsonSerializerCreditBureauLoanProduct;
    private final DefaultToApiJsonSerializer<OrganisationCreditBureauData> toApiJsonSerializerOrganisationCreditBureau;
    private final DefaultToApiJsonSerializer<CreditBureauConfigurationData> toApiJsonSerializerReport;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final CreditBureauReadConfigurationService creditBureauConfiguration;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getCreditBureau(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection creditBureau = this.readPlatformService.retrieveCreditBureau();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, creditBureau, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/mappings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getCreditBureauLoanProductMapping(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection creditBureauLoanProductMapping = this.readPlatformServiceCreditBureauLoanProduct.readCreditBureauLoanProductMapping();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerCreditBureauLoanProduct.serialize(settings, creditBureauLoanProductMapping, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/organisationCreditBureau")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getOrganisationCreditBureau(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection organisationCreditBureau = this.readPlatformServiceOrganisationCreditBureau.retrieveOrgCreditBureau();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerOrganisationCreditBureau.serialize(settings, organisationCreditBureau, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/config/{organisationCreditBureauId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getConfiguration(@PathParam(value="organisationCreditBureauId") Long organisationCreditBureauId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection configurationData = this.creditBureauConfiguration.readConfigurationByOrganisationCreditBureauId(organisationCreditBureauId.longValue());
        return this.toApiJsonSerializerReport.serialize((Object)configurationData);
    }

    @GET
    @Path(value="/loanProduct")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String fetchLoanProducts(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection creditBureauLoanProductMapping = this.readPlatformServiceCreditBureauLoanProduct.fetchLoanProducts();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerCreditBureauLoanProduct.serialize(settings, creditBureauLoanProductMapping, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/loanProduct/{loanProductId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String fetchMappingByLoanProductId(@Context UriInfo uriInfo, @PathParam(value="loanProductId") Long loanProductId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        CreditBureauLoanProductMappingData creditBureauLoanProductMapping = this.readPlatformServiceCreditBureauLoanProduct.readMappingByLoanId(loanProductId.longValue());
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerCreditBureauLoanProduct.serialize(settings, (Object)creditBureauLoanProductMapping, RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="/organisationCreditBureau")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateCreditBureau(String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCreditBureau().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="/mappings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateCreditBureauLoanProductMapping(String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCreditBureauLoanProductMapping().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="/organisationCreditBureau/{organisationCreditBureauId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String addOrganisationCreditBureau(@PathParam(value="organisationCreditBureauId") Long organisationCreditBureauId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addOrganisationCreditBureau(organisationCreditBureauId.longValue()).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="/mappings/{organisationCreditBureauId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createCreditBureauLoanProductMapping(@PathParam(value="organisationCreditBureauId") Long organisationCreditBureauId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCreditBureauLoanProductMapping(organisationCreditBureauId.longValue()).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="/configuration/{creditBureauId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createCreditBureauConfiguration(@PathParam(value="creditBureauId") Long creditBureauId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addCreditBureauConfiguration(creditBureauId.longValue()).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="/configuration/{configurationId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateCreditBureauConfiguration(@PathParam(value="configurationId") Long configurationId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCreditBureauConfiguration(configurationId.longValue()).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public CreditBureauConfigurationApiResource(PlatformSecurityContext context, CreditBureauReadPlatformService readPlatformService, DefaultToApiJsonSerializer<CreditBureauData> toApiJsonSerializer, CreditBureauLoanProductMappingReadPlatformService readPlatformServiceCreditBureauLoanProduct, OrganisationCreditBureauReadPlatformService readPlatformServiceOrganisationCreditBureau, DefaultToApiJsonSerializer<CreditBureauLoanProductMappingData> toApiJsonSerializerCreditBureauLoanProduct, DefaultToApiJsonSerializer<OrganisationCreditBureauData> toApiJsonSerializerOrganisationCreditBureau, DefaultToApiJsonSerializer<CreditBureauConfigurationData> toApiJsonSerializerReport, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, CreditBureauReadConfigurationService creditBureauConfiguration) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.readPlatformServiceCreditBureauLoanProduct = readPlatformServiceCreditBureauLoanProduct;
        this.readPlatformServiceOrganisationCreditBureau = readPlatformServiceOrganisationCreditBureau;
        this.toApiJsonSerializerCreditBureauLoanProduct = toApiJsonSerializerCreditBureauLoanProduct;
        this.toApiJsonSerializerOrganisationCreditBureau = toApiJsonSerializerOrganisationCreditBureau;
        this.toApiJsonSerializerReport = toApiJsonSerializerReport;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.creditBureauConfiguration = creditBureauConfiguration;
    }
}

