/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauConfigurationData;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauReadConfigurationService;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauReadConfigurationServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class CreditBureauReadConfigurationServiceImpl
implements CreditBureauReadConfigurationService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public CreditBureauReadConfigurationServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<CreditBureauConfigurationData> readConfigurationByOrganisationCreditBureauId(long id) {
        this.context.authenticatedUser();
        CbConfigMapper rm = new CbConfigMapper();
        String sql = "select " + rm.schema() + " where cbconfig.organisation_creditbureau_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{id});
    }

    public Map<String, String> retrieveConfigMap(long id) {
        this.context.authenticatedUser();
        CbConfigMapper rm = new CbConfigMapper();
        String sql = "select " + rm.schema() + " where cbconfig.organisation_creditbureau_id= ?";
        List config = this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{id});
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (CreditBureauConfigurationData data : config) {
            configuration.put(data.getConfigurationKey(), data.getValue());
        }
        return configuration;
    }
}

