/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.gcm.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesPropertiesReadPlatformService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.gcm.GcmConstants;
import org.apache.fineract.infrastructure.gcm.domain.Message;
import org.apache.fineract.infrastructure.gcm.domain.Notification;
import org.apache.fineract.infrastructure.gcm.domain.NotificationConfigurationData;
import org.apache.fineract.infrastructure.gcm.domain.Result;
import org.apache.fineract.infrastructure.gcm.domain.Sender;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistration;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistrationRepositoryWrapper;
import org.springframework.stereotype.Service;

@Service
public class NotificationSenderService {
    private final DeviceRegistrationRepositoryWrapper deviceRegistrationRepositoryWrapper;
    private final SmsMessageRepository smsMessageRepository;
    private final ExternalServicesPropertiesReadPlatformService propertiesReadPlatformService;

    public void sendNotification(List<SmsMessage> smsMessages) {
        Map notificationByEachClient = this.getNotificationListByClient(smsMessages);
        for (Map.Entry entry : notificationByEachClient.entrySet()) {
            this.sendNotification((Long)entry.getKey(), (List)entry.getValue());
        }
    }

    public Map<Long, List<SmsMessage>> getNotificationListByClient(List<SmsMessage> smsMessages) {
        HashMap<Long, List<SmsMessage>> notificationByEachClient = new HashMap<Long, List<SmsMessage>>();
        for (SmsMessage smsMessage : smsMessages) {
            if (smsMessage.getClient() == null) continue;
            Long clientId = (Long)smsMessage.getClient().getId();
            if (notificationByEachClient.containsKey(clientId)) {
                ((List)notificationByEachClient.get(clientId)).add(smsMessage);
                continue;
            }
            ArrayList<SmsMessage> msgList = new ArrayList<SmsMessage>(List.of(smsMessage));
            notificationByEachClient.put(clientId, msgList);
        }
        return notificationByEachClient;
    }

    public void sendNotification(Long clientId, List<SmsMessage> smsList) {
        DeviceRegistration deviceRegistration = this.deviceRegistrationRepositoryWrapper.findDeviceRegistrationByClientId(clientId);
        NotificationConfigurationData notificationConfigurationData = this.propertiesReadPlatformService.getNotificationConfiguration();
        String registrationId = null;
        if (deviceRegistration != null) {
            registrationId = deviceRegistration.getRegistrationId();
        }
        for (SmsMessage smsMessage : smsList) {
            try {
                Notification notification = new Notification.Builder("default").title("Hello !").body(smsMessage.getMessage()).build();
                Message message = new Message.Builder().notification(notification).dryRun(false).contentAvailable(Boolean.valueOf(true)).timeToLive(GcmConstants.TIME_TO_LIVE.intValue()).priority(Message.Priority.HIGH).delayWhileIdle(true).build();
                Sender sender = new Sender(notificationConfigurationData.getServerKey(), notificationConfigurationData.getFcmEndPoint());
                Result res = sender.send(message, registrationId, 3);
                if (res.getSuccess() != null && res.getSuccess() > 0) {
                    smsMessage.setStatusType(SmsMessageStatusType.SENT.getValue());
                    smsMessage.setDeliveredOnDate(DateUtils.getLocalDateTimeOfTenant());
                    continue;
                }
                if (res.getFailure() == null || res.getFailure() <= 0) continue;
                smsMessage.setStatusType(SmsMessageStatusType.FAILED.getValue());
            }
            catch (IOException e) {
                smsMessage.setStatusType(SmsMessageStatusType.FAILED.getValue());
            }
        }
        this.smsMessageRepository.saveAll(smsList);
    }

    @Generated
    public NotificationSenderService(DeviceRegistrationRepositoryWrapper deviceRegistrationRepositoryWrapper, SmsMessageRepository smsMessageRepository, ExternalServicesPropertiesReadPlatformService propertiesReadPlatformService) {
        this.deviceRegistrationRepositoryWrapper = deviceRegistrationRepositoryWrapper;
        this.smsMessageRepository = smsMessageRepository;
        this.propertiesReadPlatformService = propertiesReadPlatformService;
    }
}

