/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.apache.fineract.infrastructure.jobs.service.SchedulerVetoer;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SchedulerTriggerListener
implements TriggerListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerTriggerListener.class);
    private final TenantDetailsService tenantDetailsService;
    private final SchedulerVetoer schedulerVetoer;

    public String getName() {
        return "Fineract Global Scheduler Trigger Listener";
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        log.debug("triggerFired() trigger={}, context={}", (Object)trigger, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        String tenantIdentifier = trigger.getJobDataMap().getString("tenantIdentifier");
        FineractPlatformTenant existingTenant = ThreadLocalContextUtil.getTenant();
        boolean contextInitialized = false;
        try {
            if (existingTenant == null || !existingTenant.getTenantIdentifier().equals(tenantIdentifier)) {
                contextInitialized = true;
                FineractPlatformTenant tenant = this.tenantDetailsService.loadTenantById(tenantIdentifier);
                ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
                ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.DEFAULT);
            }
            boolean bl = this.schedulerVetoer.veto(trigger, context);
            return bl;
        }
        finally {
            if (contextInitialized) {
                ThreadLocalContextUtil.reset();
            }
        }
    }

    public void triggerMisfired(Trigger trigger) {
        log.error("triggerMisfired() trigger={}", (Object)trigger);
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        log.debug("triggerComplete() trigger={}, context={}, completedExecutionInstruction={}", new Object[]{trigger, context, triggerInstructionCode});
    }

    @Generated
    public SchedulerTriggerListener(TenantDetailsService tenantDetailsService, SchedulerVetoer schedulerVetoer) {
        this.tenantDetailsService = tenantDetailsService;
        this.schedulerVetoer = schedulerVetoer;
    }
}

