/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.interoperation.api.InteropWrapperBuilder;
import org.apache.fineract.interoperation.data.InteropAccountData;
import org.apache.fineract.interoperation.data.InteropIdentifierAccountResponseData;
import org.apache.fineract.interoperation.data.InteropIdentifierRequestData;
import org.apache.fineract.interoperation.data.InteropIdentifiersResponseData;
import org.apache.fineract.interoperation.data.InteropKycResponseData;
import org.apache.fineract.interoperation.data.InteropQuoteRequestData;
import org.apache.fineract.interoperation.data.InteropQuoteResponseData;
import org.apache.fineract.interoperation.data.InteropTransactionRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionRequestResponseData;
import org.apache.fineract.interoperation.data.InteropTransactionsData;
import org.apache.fineract.interoperation.data.InteropTransferRequestData;
import org.apache.fineract.interoperation.data.InteropTransferResponseData;
import org.apache.fineract.interoperation.domain.InteropIdentifierType;
import org.apache.fineract.interoperation.domain.InteropTransferActionType;
import org.apache.fineract.interoperation.service.InteropService;
import org.springframework.stereotype.Component;

@Path(value="/v1/interoperation")
@Component
@Tag(name="Inter Operation", description="")
public class InteropApiResource {
    private final PlatformSecurityContext context;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<CommandProcessingResult> jsonSerializer;
    private final InteropService interopService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="health")
    @Operation(summary="Query Interoperation Health Request", description="")
    @ApiResponse(responseCode="200", description="OK")
    public String health(@Context UriInfo uriInfo) {
        return "OK";
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="accounts/{accountId}")
    @Operation(summary="Query Interoperation Account details", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropAccountData.class))})
    public String getAccountDetails(@PathParam(value="accountId") @Parameter(description="accountId") String accountId, @Context UriInfo uriInfo) {
        InteropAccountData result = this.interopService.getAccountDetails(accountId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="accounts/{accountId}/transactions")
    @Operation(summary="Query transactions by Account Id", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropTransactionsData.class))})
    public String getAccountTransactions(@PathParam(value="accountId") @Parameter(description="accountId") String accountId, @DefaultValue(value="true") @QueryParam(value="debit") @Parameter(description="debit") boolean debit, @DefaultValue(value="false") @QueryParam(value="credit") @Parameter(description="credit") boolean credit, @QueryParam(value="fromBookingDateTime") @Parameter(description="fromBookingDateTime") String fromBookingDateTime, @QueryParam(value="toBookingDateTime") @Parameter(description="toBookingDateTime") String toBookingDateTime, @Context UriInfo uriInfo) {
        LocalDateTime transactionsFrom = fromBookingDateTime == null ? null : LocalDateTime.parse(fromBookingDateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        LocalDateTime transactionsTo = toBookingDateTime == null ? null : LocalDateTime.parse(toBookingDateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        InteropTransactionsData result = this.interopService.getAccountTransactions(accountId, debit, credit, transactionsFrom, transactionsTo);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="accounts/{accountId}/identifiers")
    @Operation(summary="Query Interoperation secondary identifiers by Account Id", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifiersResponseData.class))})
    public String getAccountIdentifiers(@PathParam(value="accountId") @Parameter(description="accountId") String accountId, @Context UriInfo uriInfo) {
        InteropIdentifiersResponseData result = this.interopService.getAccountIdentifiers(accountId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parties/{idType}/{idValue}")
    @Operation(summary="Query Interoperation Account by secondary identifier", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifierAccountResponseData.class))})
    public String getAccountByIdentifier(@PathParam(value="idType") @Parameter(description="idType") InteropIdentifierType idType, @PathParam(value="idValue") @Parameter(description="idValue") String idValue, @Context UriInfo uriInfo) {
        InteropIdentifierAccountResponseData result = this.interopService.getAccountByIdentifier(idType, idValue, null);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parties/{idType}/{idValue}/{subIdOrType}")
    @Operation(summary="Query Interoperation Account by secondary identifier", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifierAccountResponseData.class))})
    public String getAccountByIdentifier(@PathParam(value="idType") @Parameter(description="idType") InteropIdentifierType idType, @PathParam(value="idValue") @Parameter(description="idValue") String idValue, @PathParam(value="subIdOrType") @Parameter(description="subIdOrType") String subIdOrType, @Context UriInfo uriInfo) {
        InteropIdentifierAccountResponseData result = this.interopService.getAccountByIdentifier(idType, idValue, subIdOrType);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parties/{idType}/{idValue}")
    @Operation(summary="Interoperation Identifier registration", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropIdentifierRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifierAccountResponseData.class))})
    public String registerAccountIdentifier(@PathParam(value="idType") @Parameter(description="idType") InteropIdentifierType idType, @PathParam(value="idValue") @Parameter(description="idValue") String idValue, @Parameter(hidden=true) String identifierJson, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new InteropWrapperBuilder().registerAccountIdentifier(idType, idValue, null).withJson(identifierJson).build();
        InteropIdentifierAccountResponseData result = (InteropIdentifierAccountResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parties/{idType}/{idValue}/{subIdOrType}")
    @Operation(summary="Interoperation Identifier registration", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropIdentifierRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifierAccountResponseData.class))})
    public String registerAccountIdentifier(@PathParam(value="idType") @Parameter(description="idType") InteropIdentifierType idType, @PathParam(value="idValue") @Parameter(description="idValue") String idValue, @PathParam(value="subIdOrType") @Parameter(description="subIdOrType") String subIdOrType, @Parameter(hidden=true) String identifierJson, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new InteropWrapperBuilder().registerAccountIdentifier(idType, idValue, subIdOrType).withJson(identifierJson).build();
        InteropIdentifierAccountResponseData result = (InteropIdentifierAccountResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parties/{idType}/{idValue}")
    @Operation(summary="Allow Interoperation Identifier registration", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropIdentifierRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifierAccountResponseData.class))})
    public String deleteAccountIdentifier(@PathParam(value="idType") @Parameter(description="idType") InteropIdentifierType idType, @PathParam(value="idValue") @Parameter(description="idValue") String idValue, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new InteropWrapperBuilder().deleteAccountIdentifier(idType, idValue, null).build();
        InteropIdentifierAccountResponseData result = (InteropIdentifierAccountResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parties/{idType}/{idValue}/{subIdOrType}")
    @Operation(summary="Allow Interoperation Identifier registration", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropIdentifierRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropIdentifierAccountResponseData.class))})
    public String deleteAccountIdentifier(@PathParam(value="idType") @Parameter(description="idType") InteropIdentifierType idType, @PathParam(value="idValue") @Parameter(description="idValue") String idValue, @PathParam(value="subIdOrType") @Parameter(description="subIdOrType") String subIdOrType, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new InteropWrapperBuilder().deleteAccountIdentifier(idType, idValue, subIdOrType).build();
        InteropIdentifierAccountResponseData result = (InteropIdentifierAccountResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="transactions/{transactionCode}/requests/{requestCode}")
    @Operation(summary="Query Interoperation Transaction Request", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropTransactionRequestResponseData.class))})
    public String getTransactionRequest(@PathParam(value="transactionCode") @Parameter(description="transactionCode") String transactionCode, @PathParam(value="requestCode") @Parameter(description="requestCode") String requestCode, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("INTERREQUEST");
        InteropTransactionRequestResponseData result = this.interopService.getTransactionRequest(transactionCode, requestCode);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="requests")
    @Operation(summary="Allow Interoperation Transaction Request", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropTransactionRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropTransactionRequestResponseData.class))})
    public String createTransactionRequest(@Parameter(hidden=true) String quotesJson, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new InteropWrapperBuilder().createTransactionRequest().withJson(quotesJson).build();
        InteropTransactionRequestResponseData result = (InteropTransactionRequestResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="transactions/{transactionCode}/quotes/{quoteCode}")
    @Operation(summary="Query Interoperation Quote", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropQuoteResponseData.class))})
    public String getQuote(@PathParam(value="transactionCode") @Parameter(description="transactionCode") String transactionCode, @PathParam(value="quoteCode") @Parameter(description="quoteCode") String quoteCode, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("INTERQUOTE");
        InteropQuoteResponseData result = this.interopService.getQuote(transactionCode, quoteCode);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="quotes")
    @Operation(summary="Calculate Interoperation Quote", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropQuoteRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropQuoteResponseData.class))})
    public String createQuote(@Parameter(hidden=true) String quotesJson, @Context UriInfo uriInfo) {
        CommandWrapper commandRequest = new InteropWrapperBuilder().createQuotes().withJson(quotesJson).build();
        InteropQuoteResponseData result = (InteropQuoteResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="transactions/{transactionCode}/transfers/{transferCode}")
    @Operation(summary="Query Interoperation Transfer", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropTransferResponseData.class))})
    public String getTransfer(@PathParam(value="transactionCode") @Parameter(description="transactionCode") String transactionCode, @PathParam(value="transferCode") @Parameter(description="transferCode") String transferCode, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("INTERQUOTE");
        InteropTransferResponseData result = this.interopService.getTransfer(transactionCode, transferCode);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="transfers")
    @Operation(summary="Prepare Interoperation Transfer", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InteropTransferRequestData.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropTransferResponseData.class))})
    public String performTransfer(@QueryParam(value="action") @Parameter(description="action") String action, @Parameter(hidden=true) String quotesJson, @Context UriInfo uriInfo) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("InteropApi");
        baseDataValidator.reset().parameter("action").value((Object)action).notNull().isOneOfEnumValues(InteropTransferActionType.class);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
        CommandWrapper commandRequest = new InteropWrapperBuilder().performTransfer(InteropTransferActionType.valueOf((String)action)).withJson(quotesJson).build();
        InteropTransferResponseData result = (InteropTransferResponseData)this.commandsSourceService.logCommandSource(commandRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="accounts/{accountId}/kyc")
    @Operation(summary="Query KYC by Account Id", description="")
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InteropKycResponseData.class))})
    public String getClientKyc(@PathParam(value="accountId") @Parameter(description="accountId") String accountId, @Context UriInfo uriInfo) {
        InteropKycResponseData result = this.interopService.getKyc(accountId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jsonSerializer.serialize(settings, (Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="transactions/{accountId}/disburse")
    @Operation(summary="Disburse Loan by Account Id", description="")
    public String disburseLoan(@PathParam(value="accountId") @Parameter(description="accountId") String accountId, @Parameter(hidden=true) String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        return this.interopService.disburseLoan(accountId, apiRequestBodyAsJson);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="transactions/{accountId}/loanrepayment")
    @Operation(summary="Disburse Loan by Account Id", description="")
    public String loanRepayment(@PathParam(value="accountId") @Parameter(description="accountId") String accountId, @Parameter(hidden=true) String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        return this.interopService.loanRepayment(accountId, apiRequestBodyAsJson);
    }

    @Generated
    public InteropApiResource(PlatformSecurityContext context, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<CommandProcessingResult> jsonSerializer, InteropService interopService, PortfolioCommandSourceWritePlatformService commandsSourceService) {
        this.context = context;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.jsonSerializer = jsonSerializer;
        this.interopService = interopService;
        this.commandsSourceService = commandsSourceService;
    }
}

