/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.data.ExtensionData;
import org.apache.fineract.interoperation.data.GeoCodeData;
import org.apache.fineract.interoperation.data.InteropRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionTypeData;
import org.apache.fineract.interoperation.data.MoneyData;
import org.apache.fineract.interoperation.domain.InteropAmountType;
import org.apache.fineract.interoperation.domain.InteropTransactionRole;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;

public class InteropQuoteRequestData
extends InteropRequestData {
    static final String[] PARAMS = new String[]{"transactionCode", "requestCode", "accountId", "amount", "transactionType", "transactionRole", "note", "geoCode", "expiration", "extensionList", "quoteCode", "amountType", "fees", "locale", "dateFormat"};
    @NotNull
    private final String quoteCode;
    @NotNull
    private final InteropAmountType amountType;
    private final MoneyData fees;

    public InteropQuoteRequestData(@NotNull String transactionCode, String requestCode, @NotNull String accountId, @NotNull MoneyData amount, @NotNull InteropTransactionRole transactionRole, @NotNull InteropTransactionTypeData transactionType, String note, GeoCodeData geoCode, LocalDateTime expiration, List<ExtensionData> extensionList, @NotNull String quoteCode, @NotNull InteropAmountType amountType, MoneyData fees) {
        super(transactionCode, requestCode, accountId, amount, transactionRole, transactionType, note, geoCode, expiration, extensionList);
        this.quoteCode = quoteCode;
        this.amountType = amountType;
        this.fees = fees;
    }

    public InteropQuoteRequestData(@NotNull String transactionCode, @NotNull String accountId, @NotNull InteropAmountType amountType, @NotNull MoneyData amount, @NotNull InteropTransactionRole transactionRole, @NotNull InteropTransactionTypeData transactionType, @NotNull String quoteCode) {
        this(transactionCode, null, accountId, amount, transactionRole, transactionType, null, null, null, null, quoteCode, amountType, null);
    }

    private InteropQuoteRequestData(@NotNull InteropRequestData other, @NotNull String quoteCode, @NotNull InteropAmountType amountType, MoneyData fees) {
        this(other.getTransactionCode(), other.getRequestCode(), other.getAccountId(), other.getAmount(), other.getTransactionRole(), other.getTransactionType(), other.getNote(), other.getGeoCode(), other.getExpiration(), other.getExtensionList(), quoteCode, amountType, fees);
    }

    public String getQuoteCode() {
        return this.quoteCode;
    }

    public InteropAmountType getAmountType() {
        return this.amountType;
    }

    public MoneyData getFees() {
        return this.fees;
    }

    public void normalizeAmounts(@NotNull MonetaryCurrency currency) {
        super.normalizeAmounts(currency);
        if (this.fees != null) {
            this.fees.normalizeAmount(currency);
        }
    }

    public static InteropQuoteRequestData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, Arrays.asList(PARAMS));
        InteropRequestData interopRequestData = InteropRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)jsonHelper);
        String quoteCode = jsonHelper.extractStringNamed("quoteCode", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("quoteCode").value((Object)quoteCode).notBlank();
        String amountTypeString = jsonHelper.extractStringNamed("amountType", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("amountType").value((Object)amountTypeString).notBlank();
        InteropAmountType amountType = InteropAmountType.valueOf((String)amountTypeString);
        JsonObject feesElement = jsonHelper.extractJsonObjectNamed("fees", (JsonElement)element);
        dataValidator.merge(dataValidatorCopy);
        MoneyData fees = MoneyData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)feesElement, (FromJsonHelper)jsonHelper);
        String transactionRoleString = jsonHelper.extractStringNamed("transactionRole", (JsonElement)element);
        dataValidatorCopy = dataValidator.reset().parameter("transactionRole").value((Object)transactionRoleString).notNull();
        JsonObject transactionTypeElement = jsonHelper.extractJsonObjectNamed("transactionType", (JsonElement)element);
        dataValidatorCopy = dataValidatorCopy.reset().parameter("transactionType").value((Object)transactionTypeElement).notNull();
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new InteropQuoteRequestData(interopRequestData, quoteCode, amountType, fees);
    }
}

