/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.service;

import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.interoperation.data.InteropAccountData;
import org.apache.fineract.interoperation.data.InteropIdentifierAccountResponseData;
import org.apache.fineract.interoperation.data.InteropIdentifierRequestData;
import org.apache.fineract.interoperation.data.InteropIdentifiersResponseData;
import org.apache.fineract.interoperation.data.InteropKycData;
import org.apache.fineract.interoperation.data.InteropKycResponseData;
import org.apache.fineract.interoperation.data.InteropQuoteRequestData;
import org.apache.fineract.interoperation.data.InteropQuoteResponseData;
import org.apache.fineract.interoperation.data.InteropRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionData;
import org.apache.fineract.interoperation.data.InteropTransactionRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionRequestResponseData;
import org.apache.fineract.interoperation.data.InteropTransactionsData;
import org.apache.fineract.interoperation.data.InteropTransferRequestData;
import org.apache.fineract.interoperation.data.InteropTransferResponseData;
import org.apache.fineract.interoperation.data.MoneyData;
import org.apache.fineract.interoperation.domain.InteropActionState;
import org.apache.fineract.interoperation.domain.InteropIdentifier;
import org.apache.fineract.interoperation.domain.InteropIdentifierRepository;
import org.apache.fineract.interoperation.domain.InteropIdentifierType;
import org.apache.fineract.interoperation.exception.InteropAccountNotFoundException;
import org.apache.fineract.interoperation.exception.InteropAccountTransactionNotAllowedException;
import org.apache.fineract.interoperation.exception.InteropKycDataNotFoundException;
import org.apache.fineract.interoperation.exception.InteropTransferAlreadyCommittedException;
import org.apache.fineract.interoperation.exception.InteropTransferAlreadyOnHoldException;
import org.apache.fineract.interoperation.exception.InteropTransferMissingException;
import org.apache.fineract.interoperation.serialization.InteropDataValidator;
import org.apache.fineract.interoperation.service.InteropService;
import org.apache.fineract.interoperation.service.InteropServiceImpl;
import org.apache.fineract.interoperation.util.InteropUtil;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrency;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepository;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.account.exception.DifferentCurrenciesException;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymenttype.domain.PaymentType;
import org.apache.fineract.portfolio.paymenttype.domain.PaymentTypeRepository;
import org.apache.fineract.portfolio.savings.SavingsAccountTransactionType;
import org.apache.fineract.portfolio.savings.SavingsTransactionBooleanValues;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionSummaryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsHelper;
import org.apache.fineract.portfolio.savings.exception.InsufficientAccountBalanceException;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class InteropServiceImpl
implements InteropService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InteropServiceImpl.class);
    private final PlatformSecurityContext securityContext;
    private final InteropDataValidator dataValidator;
    private final SavingsAccountRepository savingsAccountRepository;
    private final SavingsAccountTransactionRepository savingsAccountTransactionRepository;
    private final ApplicationCurrencyRepository currencyRepository;
    private final NoteRepository noteRepository;
    private final PaymentTypeRepository paymentTypeRepository;
    private final InteropIdentifierRepository identifierRepository;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final SavingsHelper savingsHelper;
    private final SavingsAccountTransactionSummaryWrapper savingsAccountTransactionSummaryWrapper;
    private final SavingsAccountDomainService savingsAccountService;
    private final JdbcTemplate jdbcTemplate;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final DefaultToApiJsonSerializer<LoanAccountData> toApiJsonSerializer;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    @NonNull
    @Transactional
    public InteropAccountData getAccountDetails(@NonNull String accountId) {
        return InteropAccountData.build((SavingsAccount)this.validateAndGetSavingAccount(accountId));
    }

    @NonNull
    @Transactional
    public InteropTransactionsData getAccountTransactions(@NonNull String accountId, boolean debit, boolean credit, LocalDateTime transactionsFrom, LocalDateTime transactionsTo) {
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount(accountId);
        Predicate<SavingsAccountTransaction> transFilter = t -> {
            SavingsAccountTransactionType transactionType = t.getTransactionType();
            if (debit != transactionType.isDebit() && credit != transactionType.isCredit()) {
                return false;
            }
            if (transactionsFrom == null && transactionsTo == null) {
                return true;
            }
            LocalDateTime transactionDate = t.getTransactionDate().atStartOfDay(ZoneId.systemDefault()).toLocalDateTime();
            return !(transactionsTo != null && transactionsTo.compareTo(transactionDate) <= 0 || transactionsFrom != null && transactionsFrom.compareTo(transactionDate.withHour(23).withMinute(59).withSecond(59)) > 0);
        };
        InteropTransactionsData interopTransactionsData = InteropTransactionsData.build((SavingsAccount)savingsAccount, transFilter);
        for (InteropTransactionData interopTransactionData : interopTransactionsData.getTransactions()) {
            List transactionNotes = this.noteRepository.findBySavingsTransactionId(Long.valueOf(interopTransactionData.getTransactionId()));
            StringBuilder sb = new StringBuilder();
            for (Note note : transactionNotes) {
                String s = note.getNote();
                if (s == null) continue;
                sb.append(s + " ");
            }
            if (sb.toString().length() <= 0) continue;
            Object text = interopTransactionData.getNote() + " " + sb.toString();
            if (((String)text).length() > 500) {
                text = ((String)text).substring(0, 500);
            }
            interopTransactionData.updateNote((String)text);
        }
        return interopTransactionsData;
    }

    @NonNull
    @Transactional
    public InteropIdentifiersResponseData getAccountIdentifiers(@NonNull String accountId) {
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount(accountId);
        return InteropIdentifiersResponseData.build((SavingsAccount)savingsAccount);
    }

    @NonNull
    @Transactional
    public InteropIdentifierAccountResponseData getAccountByIdentifier(@NonNull InteropIdentifierType idType, @NonNull String idValue, String subIdOrType) {
        InteropIdentifier identifier = this.findIdentifier(idType, idValue, subIdOrType);
        if (identifier == null) {
            throw new InteropAccountNotFoundException(idType, idValue, subIdOrType);
        }
        return InteropIdentifierAccountResponseData.build((Long)((Long)identifier.getId()), (String)identifier.getAccount().getExternalId().getValue());
    }

    @NonNull
    @Transactional
    public InteropIdentifierAccountResponseData registerAccountIdentifier(@NonNull InteropIdentifierType idType, @NonNull String idValue, String subIdOrType, @NonNull JsonCommand command) {
        InteropIdentifierRequestData request = this.dataValidator.validateAndParseCreateIdentifier(idType, idValue, subIdOrType, command);
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount(request.getAccountId());
        try {
            AppUser createdBy = this.securityContext.authenticatedUser();
            InteropIdentifier identifier = new InteropIdentifier(savingsAccount, request.getIdType(), request.getIdValue(), request.getSubIdOrType(), createdBy.getUsername());
            this.identifierRepository.saveAndFlush((Object)identifier);
            return InteropIdentifierAccountResponseData.build((Long)((Long)identifier.getId()), (String)savingsAccount.getExternalId().getValue());
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleInteropDataIntegrityIssues(idType, request.getAccountId(), dve.getMostSpecificCause(), (Exception)dve);
            return InteropIdentifierAccountResponseData.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleInteropDataIntegrityIssues(idType, request.getAccountId(), throwable, (Exception)((Object)dve));
            return InteropIdentifierAccountResponseData.empty();
        }
    }

    @NonNull
    @Transactional
    public InteropIdentifierAccountResponseData deleteAccountIdentifier(@NonNull InteropIdentifierType idType, @NonNull String idValue, String subIdOrType) {
        InteropIdentifier identifier = this.findIdentifier(idType, idValue, subIdOrType);
        if (identifier == null) {
            throw new InteropAccountNotFoundException(idType, idValue, subIdOrType);
        }
        String accountId = identifier.getAccount().getExternalId().getValue();
        Long id = (Long)identifier.getId();
        this.identifierRepository.delete((Object)identifier);
        return InteropIdentifierAccountResponseData.build((Long)id, (String)accountId);
    }

    public InteropTransactionRequestResponseData getTransactionRequest(@NonNull String transactionCode, @NonNull String requestCode) {
        return InteropTransactionRequestResponseData.build((String)transactionCode, (InteropActionState)InteropActionState.REJECTED, (String)requestCode);
    }

    @NonNull
    @Transactional
    public InteropTransactionRequestResponseData createTransactionRequest(@NonNull JsonCommand command) {
        InteropTransactionRequestData request = this.dataValidator.validateAndParseCreateRequest(command);
        this.validateAndGetSavingAccount((InteropRequestData)request);
        return InteropTransactionRequestResponseData.build((Long)command.commandId(), (String)request.getTransactionCode(), (InteropActionState)InteropActionState.ACCEPTED, (LocalDateTime)request.getExpiration(), (List)request.getExtensionList(), (String)request.getRequestCode());
    }

    public InteropQuoteResponseData getQuote(@NonNull String transactionCode, @NonNull String quoteCode) {
        return null;
    }

    @NonNull
    @Transactional
    public InteropQuoteResponseData createQuote(@NonNull JsonCommand command) {
        BigDecimal fee;
        InteropQuoteRequestData request = this.dataValidator.validateAndParseCreateQuote(command);
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount((InteropRequestData)request);
        SavingsAccountTransactionType transactionType = request.getTransactionRole().getTransactionType();
        if (transactionType.isDebit()) {
            fee = savingsAccount.calculateWithdrawalFee(request.getAmount().getAmount());
            if (MathUtil.isLessThan((BigDecimal)savingsAccount.getWithdrawableBalance(), (BigDecimal)request.getAmount().getAmount().add(fee))) {
                throw new InsufficientAccountBalanceException(savingsAccount.getExternalId().getValue(), savingsAccount.getWithdrawableBalance(), fee, request.getAmount().getAmount());
            }
        } else {
            fee = BigDecimal.ZERO;
        }
        return InteropQuoteResponseData.build((Long)command.commandId(), (String)request.getTransactionCode(), (InteropActionState)InteropActionState.ACCEPTED, (LocalDateTime)request.getExpiration(), (List)request.getExtensionList(), (String)request.getQuoteCode(), (MoneyData)MoneyData.build((BigDecimal)fee, (String)savingsAccount.getCurrency().getCode()), null);
    }

    public InteropTransferResponseData getTransfer(@NonNull String transactionCode, @NonNull String transferCode) {
        return null;
    }

    @NonNull
    @Transactional
    public InteropTransferResponseData prepareTransfer(@NonNull JsonCommand command) {
        InteropTransferRequestData request = this.dataValidator.validateAndParseTransferRequest(command);
        String transferCode = request.getTransferCode();
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        SavingsAccountTransactionType transactionType = request.getTransactionRole().getTransactionType();
        if (transactionType.isDebit()) {
            SavingsAccount savingsAccount = this.validateAndGetSavingAccount((InteropRequestData)request);
            BigDecimal total = this.calculateTotalTransferAmount(request, savingsAccount);
            if (MathUtil.isLessThan((BigDecimal)savingsAccount.getWithdrawableBalance(), (BigDecimal)total)) {
                throw new InsufficientAccountBalanceException(savingsAccount.getExternalId().getValue(), savingsAccount.getWithdrawableBalance(), null, total);
            }
            if (this.findTransaction(savingsAccount, transferCode, SavingsAccountTransactionType.AMOUNT_HOLD.getValue()) != null) {
                throw new InteropTransferAlreadyOnHoldException(savingsAccount.getExternalId().getValue(), transferCode);
            }
            PaymentDetail paymentDetail = PaymentDetail.instance((PaymentType)this.findPaymentType(), (String)savingsAccount.getExternalId().getValue(), null, (String)this.getRoutingCode(), (String)transferCode, null);
            SavingsAccountTransaction holdTransaction = SavingsAccountTransaction.holdAmount((SavingsAccount)savingsAccount, (Office)savingsAccount.office(), (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (Money)Money.of((MonetaryCurrency)savingsAccount.getCurrency(), (BigDecimal)total), (Boolean)false);
            MonetaryCurrency accountCurrency = savingsAccount.getCurrency().copy();
            holdTransaction.setRunningBalance(Money.of((MonetaryCurrency)accountCurrency, (BigDecimal)savingsAccount.getWithdrawableBalance().subtract(holdTransaction.getAmount())));
            holdTransaction.updateCumulativeBalanceAndDates(accountCurrency, transactionDate);
            savingsAccount.holdAmount(total);
            savingsAccount.addTransaction(holdTransaction);
            this.savingsAccountRepository.save((Object)savingsAccount);
        }
        return InteropTransferResponseData.build((Long)command.commandId(), (String)request.getTransactionCode(), (InteropActionState)InteropActionState.ACCEPTED, (LocalDateTime)request.getExpiration(), (List)request.getExtensionList(), (String)transferCode, (LocalDateTime)DateUtils.getLocalDateTimeOfTenant());
    }

    @NonNull
    @Transactional
    public InteropTransferResponseData commitTransfer(@NonNull JsonCommand command) {
        SavingsAccountTransaction transaction;
        String transferCode;
        InteropTransferRequestData request = this.dataValidator.validateAndParseTransferRequest(command);
        boolean isDebit = request.getTransactionRole().getTransactionType().isDebit();
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount((InteropRequestData)request);
        if (this.findTransaction(savingsAccount, transferCode = request.getTransferCode(), (isDebit ? SavingsAccountTransactionType.WITHDRAWAL : SavingsAccountTransactionType.DEPOSIT).getValue()) != null) {
            throw new InteropTransferAlreadyCommittedException(savingsAccount.getExternalId().getValue(), transferCode);
        }
        LocalDateTime transactionDateTime = DateUtils.getLocalDateTimeOfTenant();
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        DateTimeFormatter fmt = this.getDateTimeFormatter(command);
        boolean backdatedTxnsAllowedTill = false;
        if (isDebit) {
            SavingsAccountTransaction holdTransaction = this.findTransaction(savingsAccount, transferCode, SavingsAccountTransactionType.AMOUNT_HOLD.getValue());
            if (holdTransaction == null) {
                throw new InteropTransferMissingException(savingsAccount.getExternalId().getValue(), transferCode);
            }
            BigDecimal totalTransferAmount = this.calculateTotalTransferAmount(request, savingsAccount);
            if (holdTransaction.getAmount().compareTo(totalTransferAmount) != 0) {
                throw new InteropTransferMissingException(savingsAccount.getExternalId().getValue(), transferCode);
            }
            if (MathUtil.isLessThan((BigDecimal)savingsAccount.getWithdrawableBalance().add(holdTransaction.getAmount()), (BigDecimal)totalTransferAmount)) {
                throw new InsufficientAccountBalanceException(savingsAccount.getExternalId().getValue(), savingsAccount.getWithdrawableBalance(), null, totalTransferAmount);
            }
            if (holdTransaction.getReleaseIdOfHoldAmountTransaction() == null) {
                SavingsAccountTransaction releaseTransaction = (SavingsAccountTransaction)this.savingsAccountTransactionRepository.saveAndFlush((Object)SavingsAccountTransaction.releaseAmount((SavingsAccountTransaction)holdTransaction, (LocalDate)transactionDate));
                holdTransaction.updateReleaseId((Long)releaseTransaction.getId());
                savingsAccount.releaseOnHoldAmount(holdTransaction.getAmount());
                savingsAccount.addTransaction(releaseTransaction);
                this.savingsAccountRepository.save((Object)savingsAccount);
            }
            SavingsTransactionBooleanValues transactionValues = new SavingsTransactionBooleanValues(false, true, true, false, false);
            transaction = this.savingsAccountService.handleWithdrawal(savingsAccount, fmt, transactionDate, request.getAmount().getAmount(), PaymentDetail.instance((PaymentType)this.findPaymentType(), (String)savingsAccount.getExternalId().getValue(), null, (String)this.getRoutingCode(), (String)transferCode, null), transactionValues, false);
        } else {
            transaction = this.savingsAccountService.handleDeposit(savingsAccount, fmt, transactionDate, request.getAmount().getAmount(), PaymentDetail.instance((PaymentType)this.findPaymentType(), (String)savingsAccount.getExternalId().getValue(), null, (String)this.getRoutingCode(), (String)transferCode, null), false, true, false);
        }
        String note = request.getNote();
        if (!StringUtils.isBlank((CharSequence)note)) {
            this.noteRepository.save((Object)Note.savingsTransactionNote((SavingsAccount)savingsAccount, (SavingsAccountTransaction)transaction, (String)note));
        }
        return InteropTransferResponseData.build((Long)command.commandId(), (String)request.getTransactionCode(), (InteropActionState)InteropActionState.ACCEPTED, (LocalDateTime)request.getExpiration(), (List)request.getExtensionList(), (String)request.getTransferCode(), (LocalDateTime)transactionDateTime);
    }

    @Transactional
    @NonNull
    public InteropTransferResponseData releaseTransfer(@NonNull JsonCommand command) {
        InteropTransferRequestData request = this.dataValidator.validateAndParseTransferRequest(command);
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount((InteropRequestData)request);
        LocalDateTime transactionDateTime = DateUtils.getLocalDateTimeOfTenant();
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        SavingsAccountTransaction holdTransaction = this.findTransaction(savingsAccount, request.getTransferCode(), SavingsAccountTransactionType.AMOUNT_HOLD.getValue());
        if (holdTransaction == null || holdTransaction.getReleaseIdOfHoldAmountTransaction() != null) {
            throw new InteropTransferMissingException(savingsAccount.getExternalId().getValue(), request.getTransferCode());
        }
        SavingsAccountTransaction releaseTransaction = SavingsAccountTransaction.releaseAmount((SavingsAccountTransaction)holdTransaction, (LocalDate)transactionDate);
        MonetaryCurrency accountCurrency = savingsAccount.getCurrency().copy();
        releaseTransaction.setRunningBalance(Money.of((MonetaryCurrency)accountCurrency, (BigDecimal)savingsAccount.getWithdrawableBalance().add(holdTransaction.getAmount())));
        releaseTransaction.updateCumulativeBalanceAndDates(accountCurrency, transactionDate);
        releaseTransaction = (SavingsAccountTransaction)this.savingsAccountTransactionRepository.saveAndFlush((Object)releaseTransaction);
        holdTransaction.updateReleaseId((Long)releaseTransaction.getId());
        savingsAccount.releaseOnHoldAmount(holdTransaction.getAmount());
        savingsAccount.addTransaction(releaseTransaction);
        this.savingsAccountRepository.save((Object)savingsAccount);
        return InteropTransferResponseData.build((Long)command.commandId(), (String)request.getTransactionCode(), (InteropActionState)InteropActionState.ACCEPTED, (LocalDateTime)request.getExpiration(), (List)request.getExtensionList(), (String)request.getTransferCode(), (LocalDateTime)transactionDateTime);
    }

    @NonNull
    public InteropKycResponseData getKyc(@NonNull String accountId) {
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount(accountId);
        Long clientId = (Long)savingsAccount.getClient().getId();
        try {
            KycMapper rm = new KycMapper(this.sqlGenerator);
            String sql = "select " + rm.schema() + " where c.id = ?";
            InteropKycData accountKyc = (InteropKycData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{clientId});
            return InteropKycResponseData.build((InteropKycData)accountKyc);
        }
        catch (EmptyResultDataAccessException e) {
            throw new InteropKycDataNotFoundException(clientId, (Exception)((Object)e));
        }
    }

    @NonNull
    public String disburseLoan(@NonNull String accountId, String apiRequestBodyAsJson) {
        Loan loan = this.validateAndGetLoan(accountId);
        Long loanId = (Long)loan.getId();
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandWrapper commandRequest = builder.disburseLoanApplication(loanId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @NonNull
    public String loanRepayment(@NonNull String accountId, String apiRequestBodyAsJson) {
        Loan loan = this.validateAndGetLoan(accountId);
        Long loanId = (Long)loan.getId();
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandWrapper commandRequest = builder.loanRepaymentTransaction(loanId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private SavingsAccount validateAndGetSavingAccount(String accountId) {
        SavingsAccount savingsAccount = this.savingsAccountRepository.findByExternalId(ExternalIdFactory.produce((String)accountId));
        if (savingsAccount == null) {
            throw new SavingsAccountNotFoundException(accountId);
        }
        return savingsAccount;
    }

    private Loan validateAndGetLoan(String accountId) {
        Loan loan = this.loanRepositoryWrapper.findNonClosedLoanByAccountNumber(accountId);
        if (loan == null) {
            throw new LoanNotFoundException(accountId);
        }
        return loan;
    }

    private SavingsAccount validateAndGetSavingAccount(@NonNull InteropRequestData request) {
        SavingsAccount savingsAccount = this.validateAndGetSavingAccount(request.getAccountId());
        savingsAccount.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
        ApplicationCurrency requestCurrency = this.currencyRepository.findOneByCode(request.getAmount().getCurrency());
        if (!savingsAccount.getCurrency().getCode().equals(requestCurrency.getCode())) {
            throw new DifferentCurrenciesException(savingsAccount.getCurrency().getCode(), requestCurrency.getCode());
        }
        SavingsAccountTransactionType transactionType = request.getTransactionRole().getTransactionType();
        if (!savingsAccount.isTransactionAllowed(transactionType, request.getExpirationLocalDate())) {
            throw new InteropAccountTransactionNotAllowedException(request.getAccountId());
        }
        request.normalizeAmounts(savingsAccount.getCurrency());
        return savingsAccount;
    }

    private BigDecimal calculateTotalTransferAmount(@NonNull InteropTransferRequestData request, @NonNull SavingsAccount savingsAccount) {
        MoneyData requestCommission;
        BigDecimal total = request.getAmount().getAmount();
        MoneyData requestFee = request.getFspFee();
        if (requestFee != null) {
            if (!savingsAccount.getCurrency().getCode().equals(requestFee.getCurrency())) {
                throw new DifferentCurrenciesException(savingsAccount.getCurrency().getCode(), requestFee.getCurrency());
            }
            total = MathUtil.add((BigDecimal)total, (BigDecimal)requestFee.getAmount());
        }
        if ((requestCommission = request.getFspCommission()) != null) {
            if (!savingsAccount.getCurrency().getCode().equals(requestCommission.getCurrency())) {
                throw new DifferentCurrenciesException(savingsAccount.getCurrency().getCode(), requestCommission.getCurrency());
            }
            total = MathUtil.subtractToZero((BigDecimal)total, (BigDecimal[])new BigDecimal[]{requestCommission.getAmount()});
        }
        return total;
    }

    private DateTimeFormatter getDateTimeFormatter(@NonNull JsonCommand command) {
        String dateFormat;
        Locale locale = command.extractLocale();
        if (locale == null) {
            locale = InteropUtil.DEFAULT_LOCALE;
        }
        if (StringUtils.isEmpty((CharSequence)(dateFormat = command.dateFormat()))) {
            dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        return DateTimeFormatter.ofPattern(dateFormat).withLocale(locale);
    }

    PaymentType findPaymentType() {
        List paymentTypes = this.paymentTypeRepository.findAll();
        for (PaymentType paymentType : paymentTypes) {
            if (paymentType.getIsCashPayment().booleanValue()) continue;
            return paymentType;
        }
        return null;
    }

    private SavingsAccountTransaction findTransaction(SavingsAccount savingsAccount, String transactionCode, Integer transactionTypeValue) {
        return savingsAccount.getTransactions().stream().filter(t -> transactionTypeValue.equals(t.getTypeOf())).filter(t -> {
            PaymentDetail detail = t.getPaymentDetail();
            return detail != null && this.getRoutingCode().equals(detail.getRoutingCode()) && transactionCode.equals(detail.getReceiptNumber());
        }).findFirst().orElse(null);
    }

    public InteropIdentifier findIdentifier(@NonNull InteropIdentifierType idType, @NonNull String idValue, String subIdOrType) {
        return this.identifierRepository.findOneByTypeAndValueAndSubType(idType, idValue, subIdOrType);
    }

    private void handleInteropDataIntegrityIssues(InteropIdentifierType idType, String accountId, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("uk_interop_identifier_account")) {
            throw new PlatformDataIntegrityException("error.msg.interop.duplicate.account.identifier", "Account identifier of type `" + idType.name() + "' already exists for account with externalId `" + accountId + "`", "idType", new Object[]{idType.name(), accountId});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.interop.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @NonNull
    String getRoutingCode() {
        return "INTEROPERATION";
    }

    @Generated
    public InteropServiceImpl(PlatformSecurityContext securityContext, InteropDataValidator dataValidator, SavingsAccountRepository savingsAccountRepository, SavingsAccountTransactionRepository savingsAccountTransactionRepository, ApplicationCurrencyRepository currencyRepository, NoteRepository noteRepository, PaymentTypeRepository paymentTypeRepository, InteropIdentifierRepository identifierRepository, LoanRepositoryWrapper loanRepositoryWrapper, SavingsHelper savingsHelper, SavingsAccountTransactionSummaryWrapper savingsAccountTransactionSummaryWrapper, SavingsAccountDomainService savingsAccountService, JdbcTemplate jdbcTemplate, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, DefaultToApiJsonSerializer<LoanAccountData> toApiJsonSerializer, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.securityContext = securityContext;
        this.dataValidator = dataValidator;
        this.savingsAccountRepository = savingsAccountRepository;
        this.savingsAccountTransactionRepository = savingsAccountTransactionRepository;
        this.currencyRepository = currencyRepository;
        this.noteRepository = noteRepository;
        this.paymentTypeRepository = paymentTypeRepository;
        this.identifierRepository = identifierRepository;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.savingsHelper = savingsHelper;
        this.savingsAccountTransactionSummaryWrapper = savingsAccountTransactionSummaryWrapper;
        this.savingsAccountService = savingsAccountService;
        this.jdbcTemplate = jdbcTemplate;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.sqlGenerator = sqlGenerator;
    }
}

