/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.holiday.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.api.HolidayApiConstants;
import org.apache.fineract.organisation.holiday.api.HolidaysApiResourceSwagger;
import org.apache.fineract.organisation.holiday.data.HolidayData;
import org.apache.fineract.organisation.holiday.service.HolidayReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/holidays")
@Component
@Tag(name="Holidays", description="Some MFI's span large regions where different branch offices might observe different holidays. They need the ability to define holidays for specific branch offices and be able to set the repayment rule to follow during those holidays.\n\nThe reschedule of repayments to repaymentsRescheduledTo date during defined holidays is turned on/off by enabling/disabling reschedule-repayments-on-holidays in Global configurations.\n\nAllow Repayment transactions on a defined holidays is turned on/off by enabling/disabling allow-transactions-on-holiday in Global configurations.")
public class HolidaysApiResource {
    private final DefaultToApiJsonSerializer<HolidayData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final HolidayReadPlatformService holidayReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Holiday", description="Mandatory Fields: name, description, fromDate, toDate, repaymentsRescheduledTo, offices")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.PostHolidaysRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.PostHolidaysResponse.class))})})
    public String createNewHoliday(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createHoliday().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{holidayId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Activate a Holiday", description="Always Holidays are created in pending state. This API allows to activate a holiday.\n\nOnly the active holidays are considered for rescheduling the loan repayment.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.PostHolidaysHolidayIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.PostHolidaysHolidayIdResponse.class))})})
    public String handleCommands(@PathParam(value="holidayId") @Parameter(description="holidayId") Long holidayId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.activateHoliday(holidayId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"activate"});
        }
        return this.toApiJsonSerializer.serialize(result);
    }

    @GET
    @Path(value="{holidayId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Holiday", description="Example Requests:\n\nholidays/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.GetHolidaysResponse.class))})})
    public String retrieveOne(@PathParam(value="holidayId") @Parameter(description="holidayId") Long holidayId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("holiday");
        HolidayData holidayData = this.holidayReadPlatformService.retrieveHoliday(holidayId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)holidayData, HolidayApiConstants.HOLIDAY_RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{holidayId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Holiday", description="If a holiday is in pending state (created and not activated) then all fields are allowed to modify. Once holidays become active only name and descriptions are allowed to modify.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.PutHolidaysHolidayIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.PutHolidaysHolidayIdResponse.class))})})
    public String update(@PathParam(value="holidayId") @Parameter(description="holidayId") Long holidayId, @Parameter(hidden=true) String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateHoliday(holidayId).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{holidayId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Holiday", description="This API allows to delete a holiday. This is a soft delete the deleted holiday status is marked as deleted.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=HolidaysApiResourceSwagger.DeleteHolidaysHolidayIdResponse.class))})})
    public String delete(@PathParam(value="holidayId") @Parameter(description="holidayId") Long holidayId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteHoliday(holidayId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Holidays", description="Example Requests:\n\nholidays?officeId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=HolidaysApiResourceSwagger.GetHolidaysResponse.class)))})})
    public String retrieveAllHolidays(@Context UriInfo uriInfo, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @QueryParam(value="fromDate") @Parameter(description="fromDate") DateParam fromDateParam, @QueryParam(value="toDate") @Parameter(description="toDate") DateParam toDateParam, @QueryParam(value="locale") @Parameter(description="locale") String locale, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String rawDateFormat) {
        this.context.authenticatedUser().validateHasReadPermission("holiday");
        DateFormat dateFormat = StringUtils.isBlank((CharSequence)rawDateFormat) ? null : new DateFormat(rawDateFormat);
        LocalDate fromDate = null;
        if (fromDateParam != null) {
            fromDate = fromDateParam.getDate("fromDate", dateFormat, locale);
        }
        LocalDate toDate = null;
        if (toDateParam != null) {
            toDate = toDateParam.getDate("toDate", dateFormat, locale);
        }
        Collection holidays = this.holidayReadPlatformService.retrieveAllHolidaysBySearchParamerters(officeId, fromDate, toDate);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, holidays, HolidayApiConstants.HOLIDAY_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveRepaymentScheduleUpdationTyeOptions(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("holiday");
        return this.toApiJsonSerializer.serialize((Object)this.holidayReadPlatformService.retrieveRepaymentScheduleUpdationTyeOptions());
    }

    @Generated
    public HolidaysApiResource(DefaultToApiJsonSerializer<HolidayData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, ApiRequestParameterHelper apiRequestParameterHelper, HolidayReadPlatformService holidayReadPlatformService) {
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.holidayReadPlatformService = holidayReadPlatformService;
    }
}

