/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.holiday.starter;

import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.data.HolidayDataValidator;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.holiday.service.HolidayReadPlatformService;
import org.apache.fineract.organisation.holiday.service.HolidayReadPlatformServiceImpl;
import org.apache.fineract.organisation.holiday.service.HolidayWritePlatformService;
import org.apache.fineract.organisation.holiday.service.HolidayWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class OrganisationHolidayConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={HolidayReadPlatformService.class})
    public HolidayReadPlatformService holidayReadPlatformService(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        return new HolidayReadPlatformServiceImpl(context, jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={HolidayWritePlatformService.class})
    public HolidayWritePlatformService holidayWritePlatformService(HolidayDataValidator fromApiJsonDeserializer, HolidayRepositoryWrapper holidayRepository, PlatformSecurityContext context, OfficeRepositoryWrapper officeRepositoryWrapper, FromJsonHelper fromApiJsonHelper, WorkingDaysRepositoryWrapper daysRepositoryWrapper) {
        return new HolidayWritePlatformServiceJpaRepositoryImpl(fromApiJsonDeserializer, holidayRepository, daysRepositoryWrapper, context, officeRepositoryWrapper, fromApiJsonHelper);
    }
}

