/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.teller.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.exception.StaffNotFoundException;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.organisation.teller.data.CashierData;
import org.apache.fineract.organisation.teller.data.CashierTransactionData;
import org.apache.fineract.organisation.teller.data.CashierTransactionTypeTotalsData;
import org.apache.fineract.organisation.teller.data.CashierTransactionsWithSummaryData;
import org.apache.fineract.organisation.teller.data.TellerData;
import org.apache.fineract.organisation.teller.data.TellerJournalData;
import org.apache.fineract.organisation.teller.data.TellerTransactionData;
import org.apache.fineract.organisation.teller.domain.CashierTxnType;
import org.apache.fineract.organisation.teller.service.TellerManagementReadPlatformService;
import org.apache.fineract.organisation.teller.service.TellerManagementReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class TellerManagementReadPlatformServiceImpl
implements TellerManagementReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationHelper paginationHelper;
    private final SqlValidator sqlValidator;

    private Long defaultToUsersOfficeIfNull(Long officeId) {
        Long defaultOfficeId = officeId;
        if (defaultOfficeId == null) {
            defaultOfficeId = (Long)this.context.authenticatedUser().getOffice().getId();
        }
        return defaultOfficeId;
    }

    public TellerData findTeller(Long tellerId) {
        try {
            TellerMapper tm = new TellerMapper();
            String sql = "select " + tm.schema() + " where t.id = ?";
            return (TellerData)this.jdbcTemplate.queryForObject(sql, (RowMapper)tm, new Object[]{tellerId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new StaffNotFoundException(tellerId, e);
        }
    }

    public Collection<TellerData> getTellers(Long officeId) {
        return this.retrieveAllTellers(false);
    }

    public Collection<CashierData> getCashiersForTeller(Long tellerId, LocalDate fromDate, LocalDate toDate) {
        return this.retrieveCashiersForTellers(tellerId);
    }

    public Collection<CashierData> retrieveCashiersForTellers(Long tellerId) {
        CashierMapper cm = new CashierMapper();
        String sql = "select " + cm.schema() + " where teller_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)cm, new Object[]{tellerId});
    }

    public CashierData findCashier(Long cashierId) {
        try {
            CashierMapper cm = new CashierMapper();
            String sql = "select " + cm.schema() + " where c.id = ?";
            return (CashierData)this.jdbcTemplate.queryForObject(sql, (RowMapper)cm, new Object[]{cashierId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new StaffNotFoundException(cashierId, e);
        }
    }

    public Collection<CashierData> getCashierData(Long officeId, Long tellerId, Long staffId, LocalDate date) {
        return null;
    }

    public TellerTransactionData findTellerTransaction(Long transactionId) {
        return null;
    }

    public Collection<TellerTransactionData> fetchTellerTransactionsByTellerId(Long tellerId, LocalDate fromDate, LocalDate toDate) {
        return null;
    }

    public Collection<TellerJournalData> getJournals(Long officeId, Long tellerId, Long cashierId, LocalDate dateFrom, LocalDate dateTo) {
        return null;
    }

    public Collection<TellerJournalData> fetchTellerJournals(Long tellerId, Long cashierId, LocalDate fromDate, LocalDate toDate) {
        return null;
    }

    @Cacheable(value={"tellers"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#root.target.context.authenticatedUser().getOffice().getHierarchy()+'of')")
    public Collection<TellerData> retrieveAllTellers(boolean includeAllTellers) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        Object hierarchySearchString = null;
        hierarchySearchString = includeAllTellers ? ".%" : hierarchy + "%";
        TellerMapper tm = new TellerMapper();
        String sql = "select " + tm.schema() + "where o.hierarchy like ? order by o.hierarchy";
        return this.jdbcTemplate.query(sql, (RowMapper)tm, new Object[]{hierarchySearchString});
    }

    public CashierData retrieveCashierTemplate(Long officeId, Long tellerId, boolean staffInSelectedOfficeOnly) {
        Long defaultOfficeId = this.defaultToUsersOfficeIfNull(officeId);
        OfficeData officeData = this.officeReadPlatformService.retrieveOffice(defaultOfficeId);
        String officeName = "";
        if (officeData != null) {
            officeName = officeData.getName();
        }
        TellerData tellerData = this.findTeller(tellerId);
        String tellerName = "";
        if (tellerData != null) {
            tellerName = tellerData.getName();
        }
        List staffOptions = null;
        boolean loanOfficersOnly = false;
        staffOptions = staffInSelectedOfficeOnly ? this.staffReadPlatformService.retrieveAllStaffForDropdown(defaultOfficeId) : this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(defaultOfficeId, false);
        if (CollectionUtils.isEmpty((Collection)staffOptions)) {
            staffOptions = null;
        }
        return CashierData.template((Long)officeId, (String)officeName, (Long)tellerId, (String)tellerName, (Collection)staffOptions);
    }

    public CashierTransactionData retrieveCashierTxnTemplate(Long cashierId) {
        String officeName = "";
        String tellerName = "";
        String cashierName = "";
        Long officeId = null;
        Long tellerId = null;
        LocalDate startDate = null;
        LocalDate endDate = null;
        CashierData cashierData = this.findCashier(cashierId);
        if (cashierData != null) {
            TellerData tellerData;
            cashierName = cashierData.getStaffName();
            tellerId = cashierData.getTellerId();
            if (tellerId != null && (tellerData = this.findTeller(tellerId)) != null) {
                tellerName = tellerData.getName();
                officeName = tellerData.getOfficeName();
            }
            startDate = cashierData.getStartDate();
            endDate = cashierData.getEndDate();
        }
        List currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        return CashierTransactionData.template((Long)cashierId, (Long)tellerId, (String)tellerName, officeId, (String)officeName, (String)cashierName, (CashierData)cashierData, (LocalDate)startDate, (LocalDate)endDate, (Collection)currencyOptions);
    }

    public CashierTransactionsWithSummaryData retrieveCashierTransactionsWithSummary(Long cashierId, boolean includeAllTellers, LocalDate fromDate, LocalDate toDate, String currencyCode, SearchParameters searchParameters) {
        this.sqlValidator.validate(searchParameters.getOrderBy());
        this.sqlValidator.validate(searchParameters.getSortOrder());
        String nextDay = this.sqlGenerator.incrementDateByOneDay("c.end_date");
        CashierTransactionSummaryMapper ctsm = new CashierTransactionSummaryMapper();
        String sql = "SELECT " + ctsm.cashierTxnSummarySchema(nextDay) + " LIMIT 1000";
        List cashierTxnTypeTotals = this.jdbcTemplate.query(sql, (RowMapper)ctsm, new Object[]{cashierId, currencyCode, cashierId, currencyCode, cashierId, currencyCode, cashierId, currencyCode});
        Iterator itr = cashierTxnTypeTotals.iterator();
        BigDecimal allocAmount = new BigDecimal(0);
        BigDecimal cashInAmount = new BigDecimal(0);
        BigDecimal cashOutAmount = new BigDecimal(0);
        BigDecimal settleAmount = new BigDecimal(0);
        while (itr.hasNext()) {
            CashierTransactionTypeTotalsData total = (CashierTransactionTypeTotalsData)itr.next();
            if (total == null) continue;
            if (total.getCashierTxnType().equals(CashierTxnType.ALLOCATE.getId())) {
                allocAmount = total.getCashTotal();
                continue;
            }
            if (total.getCashierTxnType().equals(CashierTxnType.SETTLE.getId())) {
                settleAmount = total.getCashTotal();
                continue;
            }
            if (total.getCashierTxnType().equals(CashierTxnType.INWARD_CASH_TXN.getId())) {
                cashInAmount = total.getCashTotal();
                continue;
            }
            if (!total.getCashierTxnType().equals(CashierTxnType.OUTWARD_CASH_TXN.getId())) continue;
            cashOutAmount = total.getCashTotal();
        }
        Page cashierTransactions = this.retrieveCashierTransactions(cashierId, includeAllTellers, fromDate, toDate, currencyCode, searchParameters);
        CashierTransactionData cashierTxnTemplate = this.retrieveCashierTxnTemplate(cashierId);
        CashierTransactionsWithSummaryData txnsWithSummary = CashierTransactionsWithSummaryData.instance((Page)cashierTransactions, (BigDecimal)allocAmount, (BigDecimal)cashInAmount, (BigDecimal)cashOutAmount, (BigDecimal)settleAmount, (String)cashierTxnTemplate.getOfficeName(), (Long)cashierTxnTemplate.getTellerId(), (String)cashierTxnTemplate.getTellerName(), (Long)cashierTxnTemplate.getCashierId(), (String)cashierTxnTemplate.getCashierName());
        return txnsWithSummary;
    }

    public Page<CashierTransactionData> retrieveCashierTransactions(Long cashierId, boolean includeAllTellers, LocalDate fromDate, LocalDate toDate, String currencyCode, SearchParameters searchParameters) {
        this.sqlValidator.validate(searchParameters.getOrderBy());
        this.sqlValidator.validate(searchParameters.getSortOrder());
        String nextDay = this.sqlGenerator.incrementDateByOneDay("c.end_date");
        CashierTransactionMapper ctm = new CashierTransactionMapper();
        String sql = "SELECT * FROM (SELECT " + ctm.cashierTxnSchema() + " WHERE txn.cashier_id = ? AND txn.currency_code = ? AND ((txn.created_date between c.start_date AND c.end_date  ) or txn.txn_type = 101))  cashier_txns  union (select " + ctm.savingsTxnSchema() + " where sav_txn.is_reversed = false and c.id = ? and sav.currency_code = ? and sav_txn.transaction_date between c.start_date and " + nextDay + " and renum.enum_value in ('deposit','withdrawal fee', 'Pay Charge', 'withdrawal', 'Annual Fee', 'Waive Charge', 'Interest Posting', 'Overdraft Interest')  and (sav_txn.payment_detail_id IS NULL OR payType.is_cash_payment = true) AND acnttrans.id IS NULL )  union (select " + ctm.loansTxnSchema() + " where loan_txn.is_reversed = false and c.id = ? and loan.currency_code = ? and loan_txn.transaction_date between c.start_date and " + nextDay + " and renum.enum_value IN ('REPAYMENT_AT_DISBURSEMENT','REPAYMENT', 'RECOVERY_REPAYMENT','DISBURSEMENT', 'CHARGE_PAYMENT', 'WAIVE_CHARGES', 'WAIVE_INTEREST', 'WRITEOFF')  and (loan_txn.payment_detail_id IS NULL OR payType.is_cash_payment = true)  AND acnttrans.id IS NULL )  union (select " + ctm.clientTxnSchema() + " where cli_txn.is_reversed = false and c.id = ? and cli_txn.currency_code = ? and cli_txn.transaction_date  between c.start_date and  " + nextDay + " and renum.enum_value IN ('PAY_CHARGE', 'WAIVE_CHARGE')  and (cli_txn.payment_detail_id IS NULL OR payType.is_cash_payment = true) )  order by created_date ";
        if (searchParameters.hasLimit()) {
            sql = sql + " ";
            sql = searchParameters.hasOffset() ? sql + this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()) : sql + this.sqlGenerator.limit(searchParameters.getLimit().intValue());
        }
        Object[] params = new Object[]{cashierId, currencyCode, cashierId, currencyCode, cashierId, currencyCode, cashierId, currencyCode};
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sql, params, (RowMapper)ctm);
    }

    @Generated
    public TellerManagementReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, OfficeReadPlatformService officeReadPlatformService, StaffReadPlatformService staffReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper, SqlValidator sqlValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.officeReadPlatformService = officeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.sqlGenerator = sqlGenerator;
        this.paginationHelper = paginationHelper;
        this.sqlValidator = sqlValidator;
    }
}

